/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.rndr.draw;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import javax.media.opengl.GL;
import javax.media.opengl.GL3;
import net.lustlab.rndr.color.Color;
import net.lustlab.rndr.math.Matrix44;
import net.lustlab.rndr.math.Transforms;
import net.lustlab.rndr.math.Vector2;
import net.lustlab.rndr.math.Vector3;
import net.lustlab.rndr.shaders.FragmentShader;
import net.lustlab.rndr.shaders.Shader;
import net.lustlab.rndr.shaders.VertexShader;
import net.lustlab.rndr.vbo.BufferWriter;
import net.lustlab.rndr.vbo.VBO;
import net.lustlab.rndr.vbo.VBODrawer;
import net.lustlab.rndr.vbo.VBOLayout;

public class SolidsRenderer {
    Shader shader;
    Map<String, VBO> vbos = new HashMap<String, VBO>();
    VBOLayout layout = new VBOLayout().textureCoordinate(2).normal(3).position(3);

    public SolidsRenderer(GL3 gl3) {
        this.shader = Shader.createShader((GL)gl3, VertexShader.load((GL)gl3, this.getClass().getResourceAsStream("/shaders/gl3/solids.vert")), FragmentShader.load((GL)gl3, this.getClass().getResourceAsStream("/shaders/gl3/solids.frag")));
        this.vbos.put("box", this.generateSolidBox(gl3));
    }

    private VBO generateSolidBox(GL3 gl3) {
        ByteBuffer buffer = ByteBuffer.allocateDirect(this.layout.size() * 6 * 6);
        BufferWriter bw = new BufferWriter(buffer);
        Vector3 nl = new Vector3(-1.0, 0.0, 0.0);
        Vector3 nr = new Vector3(1.0, 0.0, 0.0);
        Vector3 nu = new Vector3(0.0, 1.0, 0.0);
        Vector3 nd = new Vector3(0.0, -1.0, 0.0);
        Vector3 nf = new Vector3(0.0, 0.0, -1.0);
        Vector3 nb = new Vector3(0.0, 0.0, 1.0);
        Vector2 uv00 = new Vector2(0.0, 0.0);
        Vector2 uv01 = new Vector2(0.0, 1.0);
        Vector2 uv11 = new Vector2(1.0, 1.0);
        Vector2 uv10 = new Vector2(1.0, 0.0);
        double w = 0.5;
        double h = 0.5;
        double d = 0.5;
        Vector3 p000 = new Vector3(-w, h, -d);
        Vector3 p001 = new Vector3(-w, h, d);
        Vector3 p010 = new Vector3(-w, -h, -d);
        Vector3 p011 = new Vector3(-w, -h, d);
        Vector3 p100 = new Vector3(w, h, -d);
        Vector3 p101 = new Vector3(w, h, d);
        Vector3 p110 = new Vector3(w, -h, -d);
        Vector3 p111 = new Vector3(w, -h, d);
        bw.write(uv11).write(nl).write(p011).write(uv10).write(nl).write(p010).write(uv00).write(nl).write(p000);
        bw.write(uv00).write(nl).write(p000).write(uv01).write(nl).write(p001).write(uv11).write(nl).write(p011);
        bw.write(uv00).write(nr).write(p100).write(uv10).write(nr).write(p110).write(uv11).write(nr).write(p111);
        bw.write(uv11).write(nr).write(p111).write(uv01).write(nr).write(p101).write(uv00).write(nr).write(p100);
        bw.write(uv00).write(nb).write(p001).write(uv10).write(nb).write(p101).write(uv11).write(nb).write(p111);
        bw.write(uv11).write(nb).write(p111).write(uv01).write(nb).write(p011).write(uv00).write(nb).write(p001);
        bw.write(uv11).write(nf).write(p110).write(uv10).write(nf).write(p100).write(uv00).write(nf).write(p000);
        bw.write(uv00).write(nf).write(p000).write(uv01).write(nf).write(p010).write(uv11).write(nf).write(p110);
        bw.write(uv00).write(nu).write(p000).write(uv10).write(nu).write(p100).write(uv11).write(nu).write(p101);
        bw.write(uv11).write(nu).write(p101).write(uv01).write(nu).write(p001).write(uv00).write(nu).write(p000);
        bw.write(uv11).write(nd).write(p111).write(uv10).write(nd).write(p110).write(uv00).write(nd).write(p010);
        bw.write(uv00).write(nd).write(p010).write(uv01).write(nd).write(p011).write(uv11).write(nd).write(p111);
        buffer.rewind();
        VBO box = VBO.createStaticVBO((GL)gl3, buffer, this.layout.size() * 6 * 6);
        return box;
    }

    public void solid(GL gl, Matrix44 projection, Matrix44 modelView, Color fill, String solid, Vector3 offset, Vector3 dimensions) {
        this.shader.begin();
        this.shader.setUniform("projectionMatrix", projection.transpose());
        this.shader.setUniform("modelViewProjectionMatrix", projection.multiply(modelView).transpose());
        this.shader.setUniform("fill", fill);
        this.shader.setUniform("offset", offset);
        this.shader.setUniform("dimensions", dimensions);
        this.shader.setUniform("normalMatrix", Transforms.normal(modelView).transpose());
        this.vbos.get(solid).bind();
        VBODrawer.draw(gl, this.shader, this.vbos.get(solid), this.layout, 4, 36);
        this.vbos.get(solid).unbind();
        this.shader.end();
    }
}

