/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.rndr.draw;

import java.nio.FloatBuffer;
import javax.media.opengl.GL2;
import net.lustlab.rndr.color.Color;
import net.lustlab.rndr.draw.Tessellation;
import net.lustlab.rndr.draw.Vertex;

public class TessellationRenderer {
    public static void drawTessellation(GL2 gl2, Tessellation ts) {
        gl2.glMatrixMode(5888);
        gl2.glPushMatrix();
        for (Tessellation.PrimitiveData pd : ts.data) {
            gl2.glPushMatrix();
            TessellationRenderer.applyTransform(gl2, pd);
            if (pd.colorSource == Tessellation.PrimitiveData.ColorSource.Fill) {
                gl2.glColor4d(pd.polygon.fill.r, pd.polygon.fill.g, pd.polygon.fill.b, pd.polygon.fill.a);
            } else if (pd.colorSource == Tessellation.PrimitiveData.ColorSource.Stroke) {
                gl2.glColor4d(pd.polygon.stroke.r, pd.polygon.stroke.g, pd.polygon.stroke.b, pd.polygon.stroke.a);
            }
            gl2.glBegin(pd.command);
            for (Vertex vertex : pd.vertices) {
                gl2.glVertex2d(vertex.position.x, vertex.position.y);
            }
            gl2.glEnd();
            gl2.glPopMatrix();
        }
        gl2.glPopMatrix();
    }

    public static void applyTransform(GL2 gl2, Tessellation.PrimitiveData pd) {
        FloatBuffer fb = FloatBuffer.allocate(16);
        pd.polygon.transform.matrix.toFloatBuffer(fb);
        fb.rewind();
        gl2.glMultMatrixf(fb);
    }

    public static void drawTessellationSmooth(GL2 gl2, Tessellation ts) {
        TessellationRenderer.drawTessellationSmooth(gl2, ts, null, null);
    }

    public static void drawTessellationSmooth(GL2 gl2, Tessellation ts, Color fill, Color stroke) {
        gl2.glEnable(2848);
        gl2.glEnable(3042);
        gl2.glBlendFunc(770, 771);
        gl2.glPushMatrix();
        for (Tessellation.PrimitiveData pd : ts.data) {
            gl2.glPushMatrix();
            TessellationRenderer.applyTransform(gl2, pd);
            if (pd.colorSource == Tessellation.PrimitiveData.ColorSource.Fill) {
                if (fill != null) {
                    gl2.glColor4d(fill.r, fill.g, fill.b, fill.a);
                } else {
                    gl2.glColor4d(pd.polygon.fill.r, pd.polygon.fill.g, pd.polygon.fill.b, pd.polygon.fill.a);
                }
            } else if (pd.colorSource == Tessellation.PrimitiveData.ColorSource.Stroke) {
                if (stroke != null) {
                    gl2.glColor4d(stroke.r, stroke.g, stroke.b, stroke.a);
                } else {
                    gl2.glColor4d(pd.polygon.stroke.r, pd.polygon.stroke.g, pd.polygon.stroke.b, pd.polygon.stroke.a);
                }
            }
            gl2.glBegin(pd.command);
            if (pd.command == 4) {
                for (int i = 0; i < pd.vertices.size(); i += 3) {
                    Vertex v0 = pd.vertices.get(i);
                    Vertex v1 = pd.vertices.get(i + 1);
                    Vertex v2 = pd.vertices.get(i + 2);
                    gl2.glVertex2d(v0.position.x, v0.position.y);
                    gl2.glVertex2d(v1.position.x, v1.position.y);
                    gl2.glVertex2d(v2.position.x, v2.position.y);
                }
            } else {
                for (Vertex vertex : pd.vertices) {
                    gl2.glVertex2d(vertex.position.x, vertex.position.y);
                }
            }
            gl2.glEnd();
            gl2.glPopMatrix();
        }
        gl2.glPopMatrix();
    }
}

