/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.rndr.fbo;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import javax.media.opengl.GL;
import net.lustlab.rndr.gl.GLError;

public class ColorBuffer {
    public final int texture;
    public final int width;
    public final int height;
    public final int format;

    public static ColorBuffer create(GL gl, int width, int height) {
        return ColorBuffer.create(gl, width, height, 6408);
    }

    public static ColorBuffer create(GL gl, int width, int height, int format) {
        int[] textures = new int[1];
        gl.glGenTextures(1, textures, 0);
        int texture = textures[0];
        gl.glBindTexture(3553, texture);
        gl.glTexImage2D(3553, 0, format, width, height, 0, 6408, 5121, null);
        gl.glTexParameteri(3553, 10241, 9729);
        gl.glTexParameteri(3553, 10240, 9729);
        gl.glTexParameteri(3553, 10242, 33071);
        gl.glTexParameteri(3553, 10243, 33071);
        GLError.check(gl);
        return new ColorBuffer(texture, width, height, format);
    }

    public void write(GL gl, ByteBuffer bb, int type) {
        this.bindTexture(gl);
        gl.glTexSubImage2D(3553, 0, 0, 0, this.width, this.height, 6408, type, (Buffer)bb);
    }

    private ColorBuffer(int texture, int width, int height, int format) {
        this.texture = texture;
        this.width = width;
        this.height = height;
        this.format = format;
    }

    public void bindTexture(GL gl) {
        gl.glBindTexture(3553, this.texture);
    }
}

