/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.rndr.fbo;

import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureIO;
import java.io.File;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import javax.media.opengl.GL2GL3;
import net.lustlab.rndr.RNDRException;

public class FBO {
    public int framebuffer;
    public int texture;
    public int renderbuffer;
    public final int width;
    public final int height;
    GL gl;
    boolean multiSampling;
    private boolean boundTarget = false;
    int samples;
    Texture textureWrapper;
    int[] viewport = new int[4];
    int type;
    int format;

    public int getTexture() {
        return this.texture;
    }

    public FBO(GL gl, int width, int height, int format) {
        this.width = width;
        this.height = height;
        this.gl = gl;
        this.createFBO(width, height, format, 0, false, 1);
    }

    public FBO(GL gl, int width, int height, int format, int type) {
        this.gl = gl;
        this.width = width;
        this.height = height;
        this.createFBO(width, height, format, type, false, 1);
    }

    public FBO(GL gl, int width, int height, int format, int type, int samples) {
        this.gl = gl;
        this.width = width;
        this.height = height;
        this.createFBO(width, height, format, 0, true, samples);
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    public void finalize() throws Throwable {
        this.gl.glDeleteTextures(3553, new int[]{this.texture}, 0);
        this.texture = 0;
        this.gl.glDeleteRenderbuffers(1, new int[this.renderbuffer], 0);
        this.framebuffer = 0;
        this.gl.glDeleteFramebuffers(1, new int[this.framebuffer], 0);
        this.renderbuffer = 0;
        super.finalize();
    }

    public Texture getTextureWrapper() {
        return this.textureWrapper;
    }

    private void createFBO(int width, int height, int format, int type, boolean multiSampling, int samples) {
        this.format = format == 0 ? 6408 : format;
        this.type = type == 0 ? 5121 : type;
        IntBuffer framebuffers = IntBuffer.allocate(1);
        this.gl.glGenFramebuffers(1, framebuffers);
        this.framebuffer = framebuffers.get(0);
        this.gl.glBindFramebuffer(36160, this.framebuffer);
        if (multiSampling) {
            throw new RuntimeException("multi sample not implemented");
        }
        IntBuffer textures = IntBuffer.allocate(1);
        this.gl.glGenTextures(1, textures);
        this.texture = textures.get(0);
        this.gl.glBindTexture(3553, this.texture);
        this.gl.glTexImage2D(3553, 0, this.format, width, height, 0, 6408, this.type, null);
        this.gl.glTexParameteri(3553, 10241, 9729);
        this.gl.glTexParameteri(3553, 10240, 9729);
        this.gl.glTexParameteri(3553, 10242, 33071);
        this.gl.glTexParameteri(3553, 10243, 33071);
        this.gl.glFramebufferTexture2D(36160, 36064, 3553, this.texture, 0);
        this.checkFBOStatus();
        IntBuffer renderBuffers = IntBuffer.allocate(1);
        this.gl.glGenRenderbuffers(1, renderBuffers);
        this.renderbuffer = renderBuffers.get(0);
        this.gl.glBindRenderbuffer(36161, this.renderbuffer);
        if (multiSampling) {
            throw new RuntimeException("multi sampling not implemented");
        }
        this.gl.glRenderbufferStorage(36161, 33190, width, height);
        this.gl.glBindRenderbuffer(36161, 0);
        this.gl.glFramebufferRenderbuffer(36160, 36096, 36161, this.renderbuffer);
        this.checkFBOStatus();
        this.gl.glBindFramebuffer(36160, 0);
        this.multiSampling = multiSampling;
        this.samples = samples;
        this.textureWrapper = TextureIO.newTexture((int)this.texture, (int)3553, (int)width, (int)height, (int)width, (int)height, (boolean)false);
    }

    private void checkFBOStatus() {
        int status = this.gl.glCheckFramebufferStatus(36160);
        if (status != 36053) {
            throw new RNDRException("error creating framebuffer" + status);
        }
    }

    public FBO bindTarget() {
        GL2 gl2 = this.gl.getGL2();
        gl2.glGetIntegerv(2978, this.viewport, 0);
        if (this.boundTarget) {
            throw new RuntimeException("fbo is already bound as target");
        }
        this.gl.glBindFramebuffer(36160, this.framebuffer);
        this.gl.glViewport(0, 0, this.width, this.height);
        gl2.glDrawBuffer(36064);
        this.boundTarget = true;
        return this;
    }

    public FBO unbindTarget() {
        if (!this.boundTarget) {
            throw new RuntimeException("fbo is not bound as target");
        }
        this.gl.glBindFramebuffer(36160, 0);
        this.gl.glViewport(this.viewport[0], this.viewport[1], this.viewport[2], this.viewport[3]);
        this.boundTarget = false;
        return this;
    }

    public FBO bindTexture() {
        this.gl.glBindTexture(3553, this.texture);
        return this;
    }

    public FBO unbindTexture() {
        this.gl.glBindTexture(3553, 0);
        return this;
    }

    public void blit(FBO target) {
        GL2GL3 gl23 = this.gl.getGL2GL3();
        this.gl.glBindFramebuffer(36008, this.framebuffer);
        this.gl.glBindFramebuffer(36009, target.framebuffer);
        gl23.glBlitFramebuffer(0, 0, this.width, this.height, 0, 0, this.width, this.height, 16640, 9728);
        this.gl.glBindFramebuffer(36008, 0);
        this.gl.glBindFramebuffer(36009, 0);
    }

    public void write(ByteBuffer buffer) {
    }

    public void readPixels(Buffer buffer) {
        this.bindTarget();
        this.gl.glReadPixels(0, 0, this.width, this.height, this.format, this.type, buffer);
        this.unbindTarget();
    }

    public void save(File file) {
        try {
            TextureIO.write((Texture)this.textureWrapper, (File)file);
        }
        catch (IOException e) {
            throw new RNDRException(e);
        }
    }
}

