/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.rndr.fbo;

import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.media.opengl.GL;
import net.lustlab.rndr.RNDRException;
import net.lustlab.rndr.fbo.ColorBuffer;
import net.lustlab.rndr.fbo.DepthBuffer;

public class RenderTarget {
    public final int frameBuffer;
    public List<ColorBuffer> colorBuffers = new ArrayList<ColorBuffer>();
    public DepthBuffer depthBuffer;
    private GL gl;
    private boolean boundTarget;
    private int[] viewport = new int[4];
    private int width;
    private int height;
    private boolean validated = false;

    public static RenderTarget create(GL gl, int width, int height) {
        IntBuffer framebuffers = IntBuffer.allocate(1);
        gl.glGenFramebuffers(1, framebuffers);
        int frameBuffer = framebuffers.get(0);
        return new RenderTarget(gl, frameBuffer, width, height);
    }

    private RenderTarget(GL gl, int frameBuffer, int width, int height) {
        this.gl = gl;
        this.frameBuffer = frameBuffer;
        this.width = width;
        this.height = height;
    }

    public RenderTarget attach(ColorBuffer colorBuffer) {
        if (colorBuffer.width != this.width || colorBuffer.height != this.height) {
            throw new IllegalArgumentException("buffer dimension mismatch");
        }
        this.gl.glBindFramebuffer(36160, this.frameBuffer);
        this.gl.glFramebufferTexture2D(36160, 36064 + this.colorBuffers.size(), 3553, colorBuffer.texture, 0);
        int error = this.gl.glGetError();
        if (error != 0) {
            switch (error) {
                case 1280: {
                    throw new RuntimeException("Invalid enum");
                }
                case 1282: {
                    throw new RuntimeException("Invalid operation");
                }
            }
            throw new RuntimeException("I dunno");
        }
        this.colorBuffers.add(colorBuffer);
        this.boundTarget = true;
        this.checkFramebufferStatus();
        return this;
    }

    public RenderTarget attach(DepthBuffer depthBuffer) {
        if (depthBuffer.width != this.width || depthBuffer.height != this.height) {
            throw new IllegalArgumentException("buffer dimension mismatch");
        }
        this.gl.glBindFramebuffer(36160, this.frameBuffer);
        this.gl.glFramebufferTexture2D(36160, 36096, 3553, depthBuffer.texture, 0);
        int error = this.gl.glGetError();
        if (error != 0) {
            switch (error) {
                case 1280: {
                    throw new RuntimeException("Invalid enum");
                }
                case 1282: {
                    throw new RuntimeException("Invalid operation");
                }
            }
        }
        this.depthBuffer = depthBuffer;
        this.validated = false;
        this.boundTarget = true;
        this.checkFramebufferStatus();
        return this;
    }

    public RenderTarget bindTarget() {
        IntBuffer ib;
        if (!this.boundTarget) {
            this.gl.glBindFramebuffer(36160, this.frameBuffer);
            this.boundTarget = true;
            if (!this.validated) {
                this.checkFramebufferStatus();
                this.validated = true;
            }
            this.gl.glGetIntegerv(2978, this.viewport, 0);
            ib = IntBuffer.allocate(this.colorBuffers.size());
            int idx = 36064;
            for (int i = 0; i < this.colorBuffers.size(); ++i) {
                ib.put(idx);
                ++idx;
            }
        } else {
            throw new RuntimeException("fbo is already bound as target");
        }
        ib.rewind();
        this.gl.getGL2GL3().glDrawBuffers(this.colorBuffers.size(), ib);
        this.gl.glViewport(0, 0, this.width, this.height);
        return this;
    }

    public void checkFramebufferStatus() {
        int status = this.gl.glCheckFramebufferStatus(36160);
        if (status != 36053) {
            switch (status) {
                case 33305: {
                    throw new RNDRException("Framebuffer undefined");
                }
                case 36054: {
                    throw new RNDRException("Attachment incomplete");
                }
                case 36055: {
                    throw new RNDRException("Attachment missing");
                }
                case 36059: {
                    throw new RNDRException("Incomplete draw buffer");
                }
            }
            throw new RNDRException("error creating framebuffer" + status);
        }
    }

    public RenderTarget unbindTarget() {
        if (!this.boundTarget) {
            throw new RuntimeException("fbo is not bound as target");
        }
        this.gl.glBindFramebuffer(36160, 0);
        this.gl.glViewport(this.viewport[0], this.viewport[1], this.viewport[2], this.viewport[3]);
        this.boundTarget = false;
        return this;
    }
}

