/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.rndr.font;

import com.itextpdf.awt.DefaultFontMapper;
import com.itextpdf.text.FontFactory;
import com.itextpdf.text.pdf.BaseFont;
import java.awt.Font;
import java.awt.FontFormatException;
import java.io.File;
import java.io.IOException;
import net.lustlab.rndr.RNDRException;

public class FontResolver {
    public static Font resolveFileFont(String filename, int size) {
        int format = 0;
        String[] type1Extensions = new String[]{".pfb", ".pfm", ".afm", ".ofm", ".pfa"};
        if (filename.endsWith(".ttf")) {
            format = 0;
        } else {
            for (String extension : type1Extensions) {
                if (!filename.endsWith(extension)) continue;
                format = 1;
            }
        }
        File fontFile = new File(filename);
        if (fontFile.exists()) {
            try {
                Font font = Font.createFont(format, fontFile).deriveFont((float)size);
                return font;
            }
            catch (FontFormatException | IOException e) {
                throw new RNDRException(e);
            }
        }
        return null;
    }

    public static Font resolveSystemFont(String fontName, int size) {
        FontFactory.registerDirectories();
        com.itextpdf.text.Font _font = FontFactory.getFont((String)fontName);
        if (_font == null) {
            throw new RNDRException("font not found: " + fontName);
        }
        BaseFont baseFont = _font.getBaseFont();
        if (baseFont == null) {
            throw new RNDRException("font not found: " + fontName);
        }
        DefaultFontMapper dfm = new DefaultFontMapper();
        return dfm.pdfToAwt(baseFont, size);
    }
}

