/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.rndr.font.image;

import java.util.ArrayList;
import java.util.List;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import javax.media.opengl.GL3;
import net.lustlab.rndr.color.Color;
import net.lustlab.rndr.draw.Rectangle;
import net.lustlab.rndr.font.FontMap;
import net.lustlab.rndr.font.FontMapRenderer;
import net.lustlab.rndr.font.image.FontImageMap;
import net.lustlab.rndr.font.image.FontImageMapBuilder;
import net.lustlab.rndr.math.Matrix44;
import net.lustlab.rndr.shaders.FragmentShader;
import net.lustlab.rndr.shaders.Shader;

public class FontImageMapRenderer
implements FontMapRenderer {
    public static Shader shader = null;
    public double clipLeft = -1.0;
    public double clipRight = 32768.0;
    public double clipTop = -1.0;
    public double clipBottom = 32768.0;
    public Color fill = Color.WHITE;
    private Rectangle clipRectangle;
    public VerticalPositioning verticalPositioning = VerticalPositioning.Baseline;

    public FontImageMapRenderer(GL gl) {
        if (shader == null) {
            shader = Shader.createShader(gl, FragmentShader.load(gl, FontImageMapRenderer.class.getResourceAsStream("/shaders/font.frag")));
        }
    }

    @Override
    public List<FontMapRenderer.CharacterRectangle> render(GL gl, FontMap fontImageMap, String text, double x, double y) {
        return this.render(gl, fontImageMap, text, x, y, 0.0);
    }

    @Override
    public List<FontMapRenderer.CharacterRectangle> render(GL gl, FontMap fontMap, String text, double x, double y, double tracking) {
        ArrayList<FontMapRenderer.CharacterRectangle> result = new ArrayList<FontMapRenderer.CharacterRectangle>();
        if (this.fill == null) {
            return result;
        }
        gl.getGL2().glColor4d(this.fill.r, this.fill.g, this.fill.b, this.fill.a);
        FontImageMap fontImageMap = (FontImageMap)fontMap;
        if (text != null) {
            shader.begin();
            double clipLeft = -1.0;
            double clipRight = 32768.0;
            double clipTop = -1.0;
            double clipBottom = 32768.0;
            if (this.clipRectangle != null) {
                clipLeft = this.clipRectangle.x;
                clipTop = this.clipRectangle.y;
                clipRight = clipLeft + this.clipRectangle.width;
                clipBottom = clipTop + this.clipRectangle.height;
            }
            shader.setUniform4f("clipArea", (float)clipLeft, (float)clipRight, (float)clipTop, (float)clipBottom);
            int[] viewport = new int[4];
            gl.glGetIntegerv(2978, viewport, 0);
            shader.setUniform1f("viewHeight", viewport[3]);
            fontImageMap.getTexture().enable(gl);
            fontImageMap.getTexture().bind(gl);
            GL2 gl2 = gl.getGL2();
            gl2.glEnable(3042);
            gl2.glBlendFunc(1, 771);
            float xoff = 0.0f;
            for (int i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                if (c == '\u00a0') {
                    c = ' ';
                }
                if (i != 0) {
                    char left = text.charAt(i - 1);
                    xoff += fontImageMap.kerning(left, c);
                }
                if (i != 0) {
                    xoff = (float)((double)xoff + tracking);
                }
                result.add(new FontMapRenderer.CharacterRectangle(c, x + (double)((int)xoff), y, fontImageMap.getMap().get((Object)Character.valueOf((char)c)).getArea().width, fontMap.fontHeight()));
                this.renderCharacterQuad(fontImageMap, c, x + (double)((int)xoff), y, gl2);
                xoff += fontImageMap.characterWidth(c);
            }
            gl2.glBlendFunc(1, 771);
            gl2.glDisable(3042);
            fontImageMap.getTexture().disable(gl);
            shader.end();
        }
        return result;
    }

    @Override
    public List<FontMapRenderer.CharacterRectangle> render(GL3 gl, Matrix44 projection, Matrix44 modelView, FontMap fontMap, String text, double x, double y) {
        return null;
    }

    @Override
    public List<FontMapRenderer.CharacterRectangle> render(GL3 gl, Matrix44 projection, Matrix44 modelView, FontMap fontMap, String text, double x, double y, double tracking) {
        return null;
    }

    @Override
    public void clip(double left, double right, double width, double height) {
        this.clipRectangle = new Rectangle(left, right, width, height);
    }

    @Override
    public void noClip() {
        this.clipRectangle = null;
    }

    @Override
    public void fill(Color color) {
        this.fill = new Color(color);
    }

    @Override
    public void noFill() {
        this.fill = null;
    }

    @Override
    public void stroke(Color color) {
    }

    @Override
    public void noStroke() {
    }

    @Override
    public double width(FontMap fontMap, String text) {
        FontImageMap fontImageMap = (FontImageMap)fontMap;
        double width = 0.0;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (i != 0) {
                char left = text.charAt(i - 1);
                width += (double)fontImageMap.kerning(left, c);
            }
            width += (double)fontImageMap.characterWidth(c);
        }
        return width;
    }

    public void render(GL gl, FontImageMap fontImageMap, char character, int x, int y) {
        fontImageMap.getTexture().enable(gl);
        fontImageMap.getTexture().bind(gl);
        GL2 gl2 = gl.getGL2();
        gl2.glEnable(3042);
        gl2.glBlendFunc(1, 771);
        this.renderCharacterQuad(fontImageMap, character, x, y, gl2);
        gl2.glDisable(3042);
        fontImageMap.getTexture().disable(gl);
    }

    private void renderCharacterQuad(FontImageMap fontImageMap, char character, double x, double y, GL2 gl2) {
        float s = fontImageMap.getSanding();
        float packSize = fontImageMap.getTexture().getHeight();
        if (fontImageMap.getMap().get(Character.valueOf(character)) != null) {
            gl2.glBegin(7);
            double characterWidth = fontImageMap.getMap().get((Object)Character.valueOf((char)character)).getArea().width - 2.0f * s;
            double characterHeight = fontImageMap.getMap().get((Object)Character.valueOf((char)character)).getArea().height - 2.0f * s;
            double u0 = (fontImageMap.getMap().get((Object)Character.valueOf((char)character)).getArea().topLeft.x + s) / packSize;
            double v0 = (fontImageMap.getMap().get((Object)Character.valueOf((char)character)).getArea().topLeft.y + s) / packSize;
            double u1 = u0 + characterWidth / (double)packSize;
            double v1 = v0 + characterHeight / (double)packSize;
            FontImageMapBuilder.Entry e = (FontImageMapBuilder.Entry)fontImageMap.getMap().get(Character.valueOf(character)).getData();
            float xo = (float)e.pixelBounds.getMinX();
            float yo = (float)e.pixelBounds.getMinY();
            if (this.verticalPositioning == VerticalPositioning.Height) {
                yo += (float)fontImageMap.fontHeight;
            }
            gl2.glTexCoord2d(u0, v0);
            gl2.glVertex2d(x + (double)xo, y + (double)yo);
            gl2.glTexCoord2d(u1, v0);
            gl2.glVertex2d(x + characterWidth + (double)xo, y + (double)yo);
            gl2.glTexCoord2d(u1, v1);
            gl2.glVertex2d(x + characterWidth + (double)xo, y + characterHeight + (double)yo);
            gl2.glTexCoord2d(u0, v1);
            gl2.glVertex2d(x + (double)xo, y + characterHeight + (double)yo);
            gl2.glEnd();
        }
    }

    public static enum VerticalPositioning {
        Baseline,
        Height;

    }
}

