/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.rndr.font.vector;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.media.opengl.GL;
import javax.media.opengl.GL3;
import net.lustlab.rndr.color.Color;
import net.lustlab.rndr.draw.Composition;
import net.lustlab.rndr.draw.Figure;
import net.lustlab.rndr.draw.Tessellation;
import net.lustlab.rndr.draw.Vertex;
import net.lustlab.rndr.font.FontMap;
import net.lustlab.rndr.shaders.Shader;
import net.lustlab.rndr.vbo.BufferWriter;
import net.lustlab.rndr.vbo.VAO;
import net.lustlab.rndr.vbo.VBO;

public final class FontVectorMap
implements Serializable,
FontMap {
    public double fontHeight;
    public int leading;
    VBO vbo;
    VAO vao;
    public Map<Character, Entry> characters = new HashMap<Character, Entry>();

    @Override
    public double fontHeight() {
        return this.fontHeight;
    }

    @Override
    public double leading() {
        return this.leading;
    }

    public void bakeVBO(GL3 gl3, Shader shader) {
        long size = 0L;
        for (Entry entry : this.characters.values()) {
            for (Tessellation.PrimitiveData d : entry.tessellation.data) {
                size += (long)(d.vertices.size() * Tessellation.PrimitiveData.layout.size());
            }
        }
        ByteBuffer buffer = ByteBuffer.allocateDirect((int)size);
        BufferWriter bw = new BufferWriter(buffer);
        long offset = 0L;
        for (Entry entry : this.characters.values()) {
            entry.ranges = new ArrayList<VBORange>();
            for (Tessellation.PrimitiveData d : entry.tessellation.data) {
                VBORange range = new VBORange();
                range.command = d.command;
                range.offset = offset;
                range.vertices = d.vertices.size();
                for (Vertex v : d.vertices) {
                    bw.write(Color.WHITE);
                    bw.write(v.position);
                    ++offset;
                }
                entry.ranges.add(range);
            }
        }
        buffer.rewind();
        this.vbo = VBO.createStaticVBO((GL)gl3, buffer, size);
        this.vao = VAO.createVAO(gl3, this.vbo, Tessellation.PrimitiveData.layout, shader);
    }

    public static final class Entry
    implements Serializable {
        public Composition composition;
        public Figure figure;
        public Tessellation tessellation;
        public double width;
        public List<VBORange> ranges;
    }

    static final class VBORange {
        long command;
        long offset;
        long vertices;

        VBORange() {
        }
    }
}

