/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.rndr.font.vector;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import net.lustlab.rndr.draw.Composition;
import net.lustlab.rndr.draw.Figure;
import net.lustlab.rndr.draw.Tessellation;
import net.lustlab.rndr.font.FontResolver;
import net.lustlab.rndr.font.vector.FontVectorMap;
import net.lustlab.rndr.font.vector.GlyphExtractor;

public class FontVectorMapBuilder {
    public static final char[] alphabet = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00eb', '\u00e4', '\u00f6', '\u00fc', '\u00ef', '\u00ff', '\u00cb', '\u00c4', '\u00d6', '\u00dc', '\u00cf', '\u0178', '\u00f1', '\u00d1', '\u00e7', '\u00c7', '\u00f8', '\u00d8', '\u0161', '\u00e9', '\u00e1', '\u00f3', '\u00ed', '\u00fa', '\u00c9', '\u00c1', '\u00d3', '\u00cd', '\u00da', '\u00e8', '\u00e0', '\u00f2', '\u00ec', '\u00f9', '\u00c8', '\u00c0', '\u00d2', '\u00cc', '\u00d9', '\u00e2', '\u00ea', '\u00ee', '\u00fb', '\u00f4', '\u00c2', '\u00ca', '\u00ce', '\u00db', '\u00d4', '\u0153', '\u0152', '\u00e6', '\u00c6', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '!', '?', '\u00bf', '\u00a1', '\u2026', '.', ',', ' ', ':', ';', '&', '#', '\u2116', '\u201c', '\u201d', '\u2018', '\u2019', '`', '\u00a4', '\u20ac', '$', '\u00a3', '\u2012', '-', '\u2014', '\u2013', '_', '\u00b7', '\u2022', '\u00b0', '@', '^', '*', '\u00ab', '\u00bb', '/', '\\', '\"', '\'', '+', '=', '\u00f7', '~', '%', '(', ')', '[', ']', '{', '}', '<', '>'};

    public static FontVectorMap buildFontMapFromFile(String filename, int size) {
        return FontVectorMapBuilder.buildFontVectorMap(size, FontResolver.resolveFileFont(filename, size));
    }

    public static FontVectorMap buildFontMap(String fontName, int size) {
        if (!fontName.endsWith(".ttf")) {
            Font font = FontResolver.resolveSystemFont(fontName, size);
            return FontVectorMapBuilder.buildFontVectorMap(size, font);
        }
        return FontVectorMapBuilder.buildFontMapFromFile(fontName, size);
    }

    private static FontVectorMap buildFontVectorMap(int size, Font font) {
        FontVectorMap fvm = new FontVectorMap();
        GlyphExtractor extractor = new GlyphExtractor();
        FontRenderContext frc = new FontRenderContext(AffineTransform.getTranslateInstance(0.0, 0.0), false, true);
        BufferedImage offImg = new BufferedImage(100, 100, 2);
        Graphics2D graphics = offImg.createGraphics();
        graphics.setFont(font);
        FontMetrics metrics = graphics.getFontMetrics();
        Rectangle2D charBounds = font.getMaxCharBounds(frc);
        fvm.fontHeight = metrics.getMaxAscent() + metrics.getMaxDescent();
        fvm.leading = metrics.getLeading();
        for (char c : alphabet) {
            Composition composition = extractor.extractGlyph(font, size, "" + c);
            Figure figure = composition.figure();
            Tessellation tessellation = Tessellation.tessellate(figure);
            Rectangle2D bounds = font.getStringBounds("" + c, frc);
            if (!font.canDisplay(c)) continue;
            FontVectorMap.Entry entry = new FontVectorMap.Entry();
            entry.composition = composition;
            entry.figure = figure;
            entry.tessellation = tessellation;
            entry.width = bounds.getWidth();
            fvm.characters.put(Character.valueOf(c), entry);
        }
        return fvm;
    }
}

