/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.rndr.font.vector;

import java.util.ArrayList;
import java.util.List;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import javax.media.opengl.GL3;
import net.lustlab.rndr.color.Color;
import net.lustlab.rndr.draw.Rectangle;
import net.lustlab.rndr.draw.TessellationRenderer;
import net.lustlab.rndr.font.FontMap;
import net.lustlab.rndr.font.FontMapRenderer;
import net.lustlab.rndr.font.vector.FontVectorMap;
import net.lustlab.rndr.math.Matrix44;
import net.lustlab.rndr.shaders.FragmentShader;
import net.lustlab.rndr.shaders.Shader;

public class FontVectorMapRenderer
implements FontMapRenderer {
    public Color fill = Color.WHITE;
    public Color stroke = null;
    private Rectangle clipRectangle = null;
    private static Shader shader;

    @Override
    public double width(FontMap fontMap, String text) {
        FontVectorMap fontVectorMap = (FontVectorMap)fontMap;
        double width = 0.0;
        for (char c : text.toCharArray()) {
            FontVectorMap.Entry entity = fontVectorMap.characters.get(Character.valueOf(c));
            if (entity == null) continue;
            width += entity.width;
        }
        return width;
    }

    @Override
    public List<FontMapRenderer.CharacterRectangle> render(GL gl, FontMap fontMap, String text, double x, double y) {
        return this.render(gl, fontMap, text, x, y, 0.0);
    }

    @Override
    public List<FontMapRenderer.CharacterRectangle> render(GL gl, FontMap fontMap, String text, double x, double y, double tracking) {
        if (shader == null) {
            shader = Shader.createShader(gl, FragmentShader.load(gl, this.getClass().getResourceAsStream("/shaders/vectorfont.frag")));
        }
        if (this.clipRectangle != null) {
            shader.begin();
            shader.setUniform4f("clipArea", (float)this.clipRectangle.x, (float)(this.clipRectangle.x + this.clipRectangle.width), (float)this.clipRectangle.y, (float)(this.clipRectangle.y + this.clipRectangle.height));
            int[] viewport = new int[4];
            gl.glGetIntegerv(2978, viewport, 0);
            shader.setUniform1f("viewHeight", viewport[3]);
        }
        GL2 gl2 = gl.getGL2();
        ArrayList<FontMapRenderer.CharacterRectangle> result = new ArrayList<FontMapRenderer.CharacterRectangle>();
        FontVectorMap map = (FontVectorMap)fontMap;
        double cursorX = x;
        for (char c : text.toCharArray()) {
            FontVectorMap.Entry entry;
            if (c == '\u00a0') {
                c = ' ';
            }
            if ((entry = map.characters.get(Character.valueOf(c))) == null) continue;
            gl2.glPushMatrix();
            gl2.glTranslated(cursorX, y, 0.0);
            TessellationRenderer.drawTessellationSmooth(gl2, entry.tessellation, this.fill, this.stroke);
            FontMapRenderer.CharacterRectangle characterRectangle = new FontMapRenderer.CharacterRectangle(c, cursorX, y, entry.width, map.fontHeight());
            result.add(characterRectangle);
            gl2.glPopMatrix();
            cursorX += entry.width + tracking;
        }
        if (this.clipRectangle != null) {
            shader.end();
        }
        return result;
    }

    @Override
    public List<FontMapRenderer.CharacterRectangle> render(GL3 gl, Matrix44 projection, Matrix44 modelView, FontMap fontMap, String text, double x, double y) {
        return null;
    }

    @Override
    public List<FontMapRenderer.CharacterRectangle> render(GL3 gl, Matrix44 projection, Matrix44 modelView, FontMap fontMap, String text, double x, double y, double tracking) {
        return null;
    }

    @Override
    public void clip(double left, double top, double width, double height) {
        this.clipRectangle = left == 0.0 && top == 0.0 && (float)width == Float.POSITIVE_INFINITY && (float)height == Float.POSITIVE_INFINITY ? null : new Rectangle(left, top, width, height);
    }

    @Override
    public void noClip() {
        this.clipRectangle = null;
    }

    @Override
    public void fill(Color color) {
        this.fill = new Color(color);
    }

    @Override
    public void noFill() {
        this.fill = null;
    }

    @Override
    public void stroke(Color color) {
        this.stroke = color != null ? new Color(color) : null;
    }

    @Override
    public void noStroke() {
        this.stroke = null;
    }
}

