/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.rndr.image;

import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureIO;
import com.jogamp.opengl.util.texture.awt.AWTTextureIO;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import javax.media.opengl.GL;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import net.lustlab.rndr.RNDRException;
import net.lustlab.rndr.color.Color;

public final class Image {
    public String name;
    public State state;
    public boolean unloadable = true;
    long lastTouched;
    public Texture texture;
    public int width;
    public int height;
    public int[] pixels = null;
    private IntBuffer pixelBuffer;
    private GL gl;
    public URL url;

    public void setState(State state) {
        this.state = state;
    }

    public State getState() {
        return this.state;
    }

    public Image write(int x, int y, Color color) {
        int c;
        int ir = (int)(color.r * 255.0);
        int ig = (int)(color.g * 255.0);
        int ib = (int)(color.b * 255.0);
        int ia = (int)(color.a * 255.0);
        this.pixels[y * this.width + x] = c = ((ia & 0xFF) << 24) + ((ib & 0xFF) << 16) + ((ig & 0xFF) << 8) + (ir & 0xFF);
        return this;
    }

    private Image(Texture texture) {
        this.texture = texture;
        this.width = texture.getImageWidth();
        this.height = texture.getImageHeight();
    }

    public static Image createLoadable(URL url) {
        Image image = new Image();
        image.url = url;
        image.state = State.NotLoaded;
        return image;
    }

    public static Image createLoadable(File file) {
        Image image = new Image();
        try {
            image.url = file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        image.state = State.NotLoaded;
        return image;
    }

    private Image() {
    }

    public static Image fromTexture(GL gl, Texture texture) {
        return new Image(texture);
    }

    public static Image fromBufferedImage(GL gl, BufferedImage bufferedImage) {
        Texture texture = AWTTextureIO.newTexture((GLProfile)gl.getGLProfile(), (BufferedImage)bufferedImage, (boolean)true);
        Image image = new Image(texture);
        image.gl = gl;
        image.state = State.Loaded;
        return image;
    }

    public static Image drawable(GL gl, int width, int height) {
        IntBuffer textures = IntBuffer.allocate(1);
        gl.glGenTextures(1, textures);
        int textureObject = textures.get(0);
        gl.glBindTexture(3553, textureObject);
        ByteBuffer b = ByteBuffer.allocate(width * height * 4);
        for (int i = 0; i < width * height * 4; ++i) {
            byte c = (byte)(Math.random() * 255.0);
            b.put(c);
        }
        b.rewind();
        gl.glTexImage2D(3553, 0, 6408, width, height, 0, 6408, 5121, (Buffer)b);
        gl.glTexParameteri(3553, 10241, 9729);
        gl.glTexParameteri(3553, 10240, 9729);
        gl.glTexParameteri(3553, 10242, 33071);
        Texture texture = TextureIO.newTexture((int)textureObject, (int)3553, (int)width, (int)height, (int)width, (int)height, (boolean)false);
        Image image = new Image(texture);
        image.pixels = new int[width * height];
        image.pixelBuffer = IntBuffer.wrap(image.pixels);
        image.gl = gl;
        image.state = State.Loaded;
        return image;
    }

    public Image touch() {
        this.lastTouched = System.currentTimeMillis();
        return this;
    }

    public long timeSinceLastTouch() {
        return System.currentTimeMillis() - this.lastTouched;
    }

    public String toString() {
        return "Image{name='" + this.name + '\'' + ", state=" + (Object)((Object)this.state) + ", unloadable=" + this.unloadable + ", lastTouched=" + this.lastTouched + ", texture=" + this.texture + ", width=" + this.width + ", height=" + this.height + ", pixels=" + Arrays.toString(this.pixels) + ", pixelBuffer=" + this.pixelBuffer + ", gl=" + this.gl + ", url=" + this.url + "} " + super.toString();
    }

    public void save(File file) {
        try {
            TextureIO.write((Texture)this.texture, (File)file);
        }
        catch (IOException e) {
            throw new RNDRException(e);
        }
    }

    public void download() {
        if (this.pixels == null) {
            this.pixels = new int[this.texture.getImageWidth() * this.texture.getImageHeight()];
            this.pixelBuffer = IntBuffer.wrap(this.pixels);
        }
        this.texture.bind(this.gl);
        this.gl.getGL2GL3().glGetTexImage(this.texture.getTarget(), 0, 6408, 5121, (Buffer)this.pixelBuffer);
    }

    public Color sample(int x, int y) {
        if (!this.texture.getMustFlipVertically()) {
            y = this.texture.getImageHeight() - 1 - y;
        }
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        if (x >= this.texture.getImageWidth()) {
            x = this.texture.getImageWidth() - 1;
        }
        if (y >= this.texture.getImageHeight()) {
            y = this.texture.getImageHeight() - 1;
        }
        int c = this.pixels[y * this.width + x];
        Color color = new Color();
        color.r = (double)(c & 0xFF) / 255.0;
        color.g = (double)(c >> 8 & 0xFF) / 255.0;
        color.b = (double)(c >> 16 & 0xFF) / 255.0;
        color.a = (double)(c >> 24 & 0xFF) / 255.0;
        return color;
    }

    public void upload() {
        this.texture.bind(this.gl);
        this.texture.enable(this.gl);
        this.pixelBuffer.rewind();
        this.gl.getGL2GL3().glTexImage2D(this.texture.getTarget(), 0, 6408, this.texture.getWidth(), this.texture.getHeight(), 0, 6408, 5121, (Buffer)this.pixelBuffer);
    }

    public static Image loadFromFile(GL gl, String filename) {
        Image image = null;
        TextureIO.setTexRectEnabled((boolean)false);
        try {
            image = new Image(TextureIO.newTexture((File)new File(filename), (boolean)true));
        }
        catch (GLException e) {
            throw new RNDRException(e.getMessage());
        }
        catch (IOException e) {
            throw new RNDRException(e.getMessage());
        }
        if (gl.isGL3()) {
            gl.glGenerateMipmap(3553);
        }
        image.gl = gl;
        return image;
    }

    public void destroy(GL gl) {
        this.texture.destroy(gl);
    }

    public static enum State {
        NotLoaded,
        Queued,
        Loaded;

    }
}

