/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.rndr.image;

import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureIO;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Logger;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLException;
import javax.media.opengl.GLOffscreenAutoDrawable;
import javax.media.opengl.GLProfile;
import net.lustlab.rndr.RNDRException;
import net.lustlab.rndr.image.Image;

public class ImageLoader
extends Thread {
    private static Logger logger = Logger.getLogger(ImageLoader.class.getName());
    private Map<String, Image> entries = new HashMap<String, Image>();
    private static final int QueueSize = 10000;
    private final BlockingQueue<String> queue = new ArrayBlockingQueue<String>(10000);
    GLContext context;
    public final Set<Image> active = new HashSet<Image>();
    GL gl;

    public ImageLoader(GL gl) {
        GLDrawable drawable = gl.getContext().getGLDrawable();
        GLOffscreenAutoDrawable offscreen = GLDrawableFactory.getFactory((GLProfile)drawable.getGLProfile()).createOffscreenAutoDrawable(null, drawable.getChosenGLCapabilities(), null, 640, 480);
        offscreen.setSharedContext(gl.getContext());
        offscreen.display();
        this.gl = gl;
        this.context = offscreen.getContext();
    }

    public ImageLoader(GLContext context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getImage(String name) {
        Map<String, Image> map = this.entries;
        synchronized (map) {
            Image entry = this.entries.get(name);
            if (entry == null) {
                entry = Image.createLoadable(new File(name));
                entry.name = name;
                this.entries.put(name, entry);
            }
            return entry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getImage(URL url) {
        Map<String, Image> map = this.entries;
        synchronized (map) {
            Image entry = this.entries.get(url.toString());
            if (entry == null) {
                entry = Image.createLoadable(url);
                entry.name = url.toString();
                this.entries.put(url.toString(), entry);
            }
            return entry;
        }
    }

    public void queue(Image entry) {
        logger.info("queued: " + entry + " " + this.queue.size());
        this.getImage(entry.name).setState(Image.State.Queued);
        this.queue.offer(entry.name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (true) {
                this.context.makeCurrent();
                Set<Image> set = this.active;
                synchronized (set) {
                    ArrayList<Image> toRemove = new ArrayList<Image>();
                    for (Image entry : this.active) {
                        long delta = entry.timeSinceLastTouch();
                        if (delta <= 1000L || !entry.unloadable) continue;
                        logger.info("unloading texture for: " + entry);
                        if (entry.texture != null) {
                            entry.texture.destroy(this.context.getGL());
                        }
                        entry.texture = null;
                        entry.setState(Image.State.NotLoaded);
                        toRemove.add(entry);
                    }
                    for (Image entry : toRemove) {
                        this.active.remove(entry);
                    }
                }
                String index = this.queue.take();
                Image entry = this.getImage(index);
                long timeSinceTouch = entry.timeSinceLastTouch();
                if (timeSinceTouch < 3500L || !entry.unloadable) {
                    try {
                        TextureIO.setTexRectEnabled((boolean)false);
                        Texture texture = null;
                        texture = TextureIO.newTexture((URL)entry.url, (boolean)true, null);
                        if (this.gl.isGL3()) {
                            texture.bind(this.gl);
                            this.gl.getGL3().glGenerateMipmap(3553);
                            this.gl.glBindTexture(3553, 0);
                        }
                        this.context.getGL().glFinish();
                        Object object = this.entries;
                        synchronized (object) {
                            entry.texture = texture;
                            entry.setState(Image.State.Loaded);
                            entry.width = entry.texture.getWidth();
                            entry.height = entry.texture.getHeight();
                            logger.info("loaded image: " + entry);
                        }
                        entry.touch();
                        object = this.active;
                        synchronized (object) {
                            this.active.add(entry);
                        }
                    }
                    catch (GLException e) {
                        logger.severe("OpenGLException while loading: " + entry);
                    }
                    catch (IOException e) {
                        logger.severe("IO exception while loading:  " + entry);
                    }
                    continue;
                }
                Map<String, Image> map = this.entries;
                synchronized (map) {
                    entry.setState(Image.State.NotLoaded);
                    entry.texture = null;
                }
            }
        }
        catch (InterruptedException e) {
            throw new RNDRException(e);
        }
    }
}

