/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.rndr.math;

import java.io.Serializable;
import net.lustlab.rndr.math.Matrix22;
import net.lustlab.rndr.math.Matrix44;

public class Vector2
implements Serializable {
    public static final Vector2 UnitX = new Vector2(1.0, 0.0);
    public static final Vector2 UnitY = new Vector2(0.0, 1.0);
    public static final Vector2 Zero = new Vector2(0.0, 0.0);
    public static final Vector2 Infinity = new Vector2(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    public double x;
    public double y;

    public String toString() {
        return "Vector2{x=" + this.x + ", y=" + this.y + '}';
    }

    public Vector2() {
        this.x = 0.0;
        this.y = 0.0;
    }

    public Vector2(Vector2 that) {
        this.x = that.x;
        this.y = that.y;
    }

    public Vector2(double[] v) {
        this.x = v[0];
        this.y = v[1];
    }

    public Vector2(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Vector2(double v) {
        this.x = v;
        this.y = v;
    }

    public double squaredLength() {
        return this.x * this.x + this.y * this.y;
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public Vector2 multiply(Matrix44 m) {
        return new Vector2(this.x * m.m00 + this.y * m.m10 + m.m30, this.x * m.m01 + this.y * m.m11 + m.m31);
    }

    public Vector2 scale(double s) {
        return new Vector2(this.x * s, this.y * s);
    }

    public Vector2 scale(double xs, double ys, double zs) {
        return new Vector2(this.x * xs, this.y * ys);
    }

    public Vector2 add(Vector2 other) {
        return new Vector2(this.x + other.x, this.y + other.y);
    }

    public Vector2 subtract(Vector2 other) {
        return new Vector2(this.x - other.x, this.y - other.y);
    }

    public Vector2 mask(Vector2 other) {
        return new Vector2(this.x * other.x, this.y * other.y);
    }

    public double dot(Vector2 other) {
        return this.x * other.x + this.y * other.y;
    }

    public Vector2 normalized() {
        double l = this.length();
        if (l == 0.0) {
            l = 1.0;
        }
        return new Vector2(this.x / l, this.y / l);
    }

    public Vector2 copy() {
        return new Vector2(this);
    }

    public Vector2 multiply(Matrix22 m) {
        return new Vector2(this.x * m.m00 + this.y * m.m10, this.x * m.m01 + this.y * m.m11);
    }
}

