/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.rndr.math;

import java.io.Serializable;

public class Vector4
implements Serializable {
    public double x;
    public double y;
    public double z;
    public double w;
    public static final Vector4 Zero = new Vector4(0.0, 0.0, 0.0, 0.0);
    public static final Vector4 UnitX = new Vector4(1.0, 0.0, 0.0, 0.0);
    public static final Vector4 UnitY = new Vector4(0.0, 1.0, 0.0, 0.0);
    public static final Vector4 UnitZ = new Vector4(0.0, 0.0, 1.0, 0.0);
    public static final Vector4 UnitW = new Vector4(0.0, 0.0, 0.0, 1.0);

    public Vector4() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
        this.w = 0.0;
    }

    public Vector4(double[] v) {
        this.x = v[0];
        this.y = v[1];
        this.z = v[2];
        this.w = v[3];
    }

    public Vector4(double x, double y, double z, double w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public Vector4(double v) {
        this.x = v;
        this.y = v;
        this.z = v;
        this.w = v;
    }

    public double squaredLength() {
        return this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w);
    }

    public Vector4 scale(double s) {
        return new Vector4(this.x * s, this.y * s, this.z * s, this.w * s);
    }

    public Vector4 scale(double xs, double ys, double zs, double ws) {
        return new Vector4(this.x * xs, this.y * ys, this.z * zs, this.w * ws);
    }

    public Vector4 add(Vector4 other) {
        return new Vector4(this.x + other.x, this.y + other.y, this.z + other.z, this.w + other.w);
    }

    public Vector4 subtract(Vector4 other) {
        return new Vector4(this.x - other.x, this.y - other.y, this.z - other.z, this.w - other.w);
    }

    public Vector4 mask(Vector4 other) {
        return new Vector4(this.x * other.x, this.y * other.y, this.z * other.z, this.w * other.z);
    }

    public double dot(Vector4 other) {
        return this.x * other.x + this.y * other.y + this.z * other.z + this.w * other.w;
    }

    public Vector4 normalized() {
        double l = this.length();
        if (l == 0.0) {
            l = 1.0;
        }
        return new Vector4(this.x / l, this.y / l, this.z / l, this.w / l);
    }
}

