/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.rndr.post;

import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import net.lustlab.rndr.fbo.FBO;
import net.lustlab.rndr.post.Grayscale;
import net.lustlab.rndr.post.Hipstergraph;
import net.lustlab.rndr.post.PostProcessor;
import net.lustlab.rndr.shaders.FragmentShader;
import net.lustlab.rndr.shaders.Shader;
import net.lustlab.rndr.shaders.VertexShader;

public class MotionBlur
extends PostProcessor {
    static Shader blurShader = null;
    public double radius = 1.0;
    public int window = 15;
    public int passes = 2;
    FBO[] tempFBOs;

    public MotionBlur(GL gl, int width, int height) {
        VertexShader vert = VertexShader.load(gl, Grayscale.class.getResourceAsStream("/shaders/post_common.vert"));
        if (blurShader == null) {
            blurShader = Shader.createShader(gl, vert, FragmentShader.load(gl, Hipstergraph.class.getResourceAsStream("/shaders/post_motionblur.frag")));
        }
        this.tempFBOs = new FBO[2];
        for (int i = 0; i < 2; ++i) {
            this.tempFBOs[i] = new FBO(gl, width, height, 0);
        }
    }

    @Override
    public void render(GL gl, FBO input, FBO target) {
        GL2 gl2 = gl.getGL2();
        gl2.glDisable(2929);
        float u0 = 0.0f;
        float v0 = 0.0f;
        float u1 = 1.0f;
        float v1 = 1.0f;
        float[][] blurDirections = new float[][]{{0.0f / (float)input.width, -1.0f / (float)input.height()}};
        blurShader.begin();
        blurShader.setUniform1i("texture", 0);
        blurShader.setUniform1i("window", this.window);
        gl2.glEnable(3553);
        for (int pass = 0; pass < this.passes * 2; ++pass) {
            FBO passInput = null;
            FBO passTarget = null;
            passInput = pass == 0 ? input : this.tempFBOs[pass % 2];
            passTarget = pass == this.passes * 2 - 1 ? target : this.tempFBOs[(pass + 1) % 2];
            passInput.bindTexture();
            gl2.glTexParameteri(3553, 10243, 33069);
            gl2.glTexParameteri(3553, 10242, 33069);
            gl2.glTexParameterfv(3553, 4100, new float[]{0.0f, 0.0f, 0.0f, 1.0f}, 0);
            if (passTarget != null) {
                passTarget.bindTarget();
            }
            int dirs = 1;
            blurShader.setUniform2f("blurDirection", (float)this.radius * blurDirections[pass % dirs][0], (float)this.radius * blurDirections[pass % dirs][1]);
            gl2.glBegin(7);
            gl2.glColor4d(1.0, 1.0, 1.0, 1.0);
            gl2.glMultiTexCoord2f(33984, 0.0f, 0.0f);
            gl2.glVertex2f(-1.0f, -1.0f);
            gl2.glMultiTexCoord2f(33984, 1.0f, 0.0f);
            gl2.glVertex2f(1.0f, -1.0f);
            gl2.glMultiTexCoord2f(33984, 1.0f, 1.0f);
            gl2.glVertex2f(1.0f, 1.0f);
            gl2.glMultiTexCoord2f(33984, 0.0f, 1.0f);
            gl2.glVertex2f(-1.0f, 1.0f);
            gl2.glEnd();
            passInput.unbindTexture();
            if (passTarget == null) continue;
            passTarget.unbindTarget();
        }
        blurShader.end();
    }
}

