/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.rndr.shaders;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.logging.Logger;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import javax.media.opengl.GL3;
import net.lustlab.rndr.shaders.ShaderException;

public final class ShaderInfo {
    public static void checkShaderInfoLog(GL gl, int object, String sourceFile) {
        if (gl.isGL2()) {
            GL2 gl2 = gl.getGL2();
            IntBuffer iVal = IntBuffer.allocate(1);
            gl2.glGetObjectParameterivARB(object, 35716, iVal);
            int length = iVal.get();
            if (length <= 1) {
                return;
            }
            ByteBuffer infoLog = ByteBuffer.allocate(length);
            iVal.flip();
            gl2.glGetInfoLogARB(object, length, iVal, infoLog);
            byte[] infoBytes = new byte[length];
            infoLog.get(infoBytes);
            Logger.getLogger(ShaderInfo.class.getName()).severe("GLSL Validation >> " + new String(infoBytes));
            throw new ShaderException("Shader error in " + sourceFile);
        }
        if (gl.isGL3()) {
            GL3 gl3 = gl.getGL3();
            IntBuffer iVal = IntBuffer.allocate(1);
            gl3.glGetShaderiv(object, 35716, iVal);
            iVal.rewind();
            int logLength = iVal.get();
            if (logLength == 0) {
                System.out.println("no log");
                return;
            }
            ByteBuffer infoLog = ByteBuffer.allocate(logLength);
            iVal.flip();
            gl3.glGetShaderInfoLog(object, logLength, iVal, infoLog);
            byte[] infoBytes = new byte[logLength];
            infoLog.get(infoBytes);
            Logger.getLogger(ShaderInfo.class.getName()).severe("GLSL Validation >> " + new String(infoBytes));
            throw new ShaderException("Shader error: " + sourceFile);
        }
    }

    public static void checkProgramInfoLog(GL gl, int object, String sourceFile) {
        if (gl.isGL3()) {
            GL3 gl3 = gl.getGL3();
            IntBuffer iVal = IntBuffer.allocate(1);
            gl3.glGetProgramiv(object, 35716, iVal);
            iVal.rewind();
            int logLength = iVal.get();
            if (logLength == 0) {
                return;
            }
            ByteBuffer infoLog = ByteBuffer.allocate(logLength);
            iVal.flip();
            gl3.glGetProgramInfoLog(object, logLength, iVal, infoLog);
            byte[] infoBytes = new byte[logLength];
            infoLog.get(infoBytes);
            Logger.getLogger(ShaderInfo.class.getName()).severe("link problems:" + new String(infoBytes));
        }
    }
}

