/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.rndr.shaders;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.lustlab.rndr.color.Color;
import net.lustlab.rndr.math.Vector2;
import net.lustlab.rndr.math.Vector3;
import net.lustlab.rndr.math.Vector4;

public class Std140Writer {
    final ByteBuffer buffer;

    public Std140Writer(ByteBuffer buffer) {
        buffer.order(ByteOrder.nativeOrder());
        this.buffer = buffer;
    }

    void pad(int alignment) {
        int position = this.buffer.position();
        int padding = position % alignment != 0 ? alignment - position % alignment : 0;
        for (int i = 0; i < padding; ++i) {
            this.buffer.put((byte)0);
        }
    }

    public Std140Writer write(float v) {
        this.buffer.putFloat(v);
        return this;
    }

    public Std140Writer write(float v0, float v1) {
        this.pad(8);
        this.buffer.putFloat(v0).putFloat(v1);
        return this;
    }

    public Std140Writer write(float v0, float v1, float v2) {
        this.pad(16);
        this.buffer.putFloat(v0).putFloat(v1).putFloat(v2);
        return this;
    }

    public Std140Writer write(float v0, float v1, float v2, float v3) {
        this.pad(16);
        this.buffer.putFloat(v0).putFloat(v1).putFloat(v2).putFloat(v3);
        return this;
    }

    public Std140Writer writeArray(float[] vs) {
        for (float v : vs) {
            this.buffer.putFloat(v);
        }
        this.pad(16);
        return this;
    }

    public Std140Writer writeArray(Vector3[] vs) {
        for (Vector3 v : vs) {
            this.buffer.putFloat((float)v.x).putFloat((float)v.y).putFloat((float)v.z).putFloat(0.0f);
        }
        this.pad(16);
        return this;
    }

    public Std140Writer write(Vector3 v3) {
        this.pad(16);
        this.buffer.putFloat((float)v3.x);
        this.buffer.putFloat((float)v3.y);
        this.buffer.putFloat((float)v3.z);
        return this;
    }

    public Std140Writer write(Vector4 v4) {
        this.pad(16);
        this.buffer.putFloat((float)v4.x);
        this.buffer.putFloat((float)v4.y);
        this.buffer.putFloat((float)v4.z);
        this.buffer.putFloat((float)v4.w);
        return this;
    }

    public Std140Writer write(Vector2 v2) {
        this.pad(8);
        this.buffer.putFloat((float)v2.x);
        this.buffer.putFloat((float)v2.y);
        return this;
    }

    public Std140Writer write(Color c) {
        this.pad(16);
        this.buffer.putFloat((float)c.r);
        this.buffer.putFloat((float)c.g);
        this.buffer.putFloat((float)c.b);
        this.buffer.putFloat((float)c.a);
        return this;
    }
}

