/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.rndr.shaders;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import javax.media.opengl.GL2GL3;

public class UBO {
    final int ubo;
    final int sizeInBytes;
    private ByteBuffer mappedBuffer;
    GL2GL3 gl23;

    public UBO create(GL2GL3 gl23, int sizeInBytes) {
        int[] ubos = new int[1];
        gl23.glGenBuffers(1, ubos, 0);
        gl23.glBindBuffer(35345, ubos[0]);
        gl23.glBufferData(35345, (long)sizeInBytes, null, 35040);
        gl23.glBindBuffer(35345, 0);
        return new UBO(gl23, ubos[0], sizeInBytes);
    }

    UBO(GL2GL3 gl23, int ubo, int sizeInBytes) {
        this.gl23 = gl23;
        this.ubo = ubo;
        this.sizeInBytes = sizeInBytes;
    }

    public UBO bind() {
        this.gl23.glBindBuffer(35345, this.ubo);
        return this;
    }

    public UBO unbind() {
        this.gl23.glBindBuffer(35345, 0);
        return this;
    }

    public UBO map() {
        if (this.mappedBuffer == null) {
            this.bind();
            this.mappedBuffer = this.gl23.glMapBuffer(35345, 35001);
            if (this.mappedBuffer == null) {
                throw new RuntimeException("ubo map failed");
            }
            return this;
        }
        throw new RuntimeException("ubo already mapped");
    }

    public UBO unmap() {
        if (this.mappedBuffer != null) {
            this.bind();
            this.mappedBuffer = null;
            this.gl23.glUnmapBuffer(35345);
            return this;
        }
        throw new RuntimeException("ubo not mapped");
    }

    public ByteBuffer getMappedBuffer() {
        return this.mappedBuffer;
    }

    public UBO write(ByteBuffer source) {
        if (this.mappedBuffer != null) {
            this.bind();
            this.gl23.glBufferSubData(35345, 0L, (long)source.remaining(), (Buffer)source);
            return this;
        }
        throw new RuntimeException("cannot write while ubo is mapped");
    }

    public UBO read(ByteBuffer target) {
        if (this.mappedBuffer != null) {
            this.bind();
            this.gl23.glGetBufferSubData(35345, 0L, (long)this.sizeInBytes, (Buffer)target);
            return this;
        }
        throw new RuntimeException("cannot read while ubo is mapped");
    }
}

