/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.rndr.vbo;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.lustlab.rndr.color.Color;
import net.lustlab.rndr.math.Vector2;
import net.lustlab.rndr.math.Vector3;
import net.lustlab.rndr.math.Vector4;

public class BufferWriter {
    private final ByteBuffer buffer;

    public BufferWriter(ByteBuffer buffer) {
        buffer.order(ByteOrder.nativeOrder());
        this.buffer = buffer;
    }

    public BufferWriter write(int i) {
        if (this.buffer != null) {
            this.buffer.putInt(i);
        }
        return this;
    }

    public BufferWriter write(Vector3 vector3) {
        if (this.buffer != null) {
            this.buffer.putFloat((float)vector3.x);
            this.buffer.putFloat((float)vector3.y);
            this.buffer.putFloat((float)vector3.z);
        }
        return this;
    }

    public BufferWriter write(float x) {
        if (this.buffer != null) {
            this.buffer.putFloat(x);
        }
        return this;
    }

    public BufferWriter write(float[] xs) {
        if (this.buffer != null) {
            for (float x : xs) {
                this.buffer.putFloat(x);
            }
        }
        return this;
    }

    public BufferWriter write(double[] xs) {
        if (this.buffer != null) {
            for (double x : xs) {
                this.buffer.putFloat((float)x);
            }
        }
        return this;
    }

    public BufferWriter write(double x, double y) {
        if (this.buffer != null) {
            this.buffer.putFloat((float)x);
            this.buffer.putFloat((float)y);
        }
        return this;
    }

    public BufferWriter write(double x, double y, double z) {
        if (this.buffer != null) {
            this.buffer.putFloat((float)x);
            this.buffer.putFloat((float)y);
            this.buffer.putFloat((float)z);
        }
        return this;
    }

    public BufferWriter write(double x, double y, double z, double w) {
        if (this.buffer != null) {
            this.buffer.putFloat((float)x);
            this.buffer.putFloat((float)y);
            this.buffer.putFloat((float)z);
            this.buffer.putFloat((float)w);
        }
        return this;
    }

    public BufferWriter write(Color color) {
        if (this.buffer != null) {
            this.buffer.putFloat((float)color.r);
            this.buffer.putFloat((float)color.g);
            this.buffer.putFloat((float)color.b);
            this.buffer.putFloat((float)color.a);
        }
        return this;
    }

    public BufferWriter write(Vector4 vector4) {
        if (this.buffer != null) {
            this.buffer.putFloat((float)vector4.x);
            this.buffer.putFloat((float)vector4.y);
            this.buffer.putFloat((float)vector4.z);
            this.buffer.putFloat((float)vector4.w);
        }
        return this;
    }

    public BufferWriter write(Vector2 vector2) {
        if (this.buffer != null) {
            this.buffer.putFloat((float)vector2.x);
            this.buffer.putFloat((float)vector2.y);
        }
        return this;
    }
}

