/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.rndr.vbo;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import javax.media.opengl.GL;
import javax.media.opengl.GL2GL3;
import net.lustlab.rndr.RNDRException;
import net.lustlab.rndr.color.Color;
import net.lustlab.rndr.gl.GLError;
import net.lustlab.rndr.math.Vector2;
import net.lustlab.rndr.math.Vector3;
import net.lustlab.rndr.math.Vector4;

public class VBO {
    public final int vbo;
    private final ByteBuffer sourceBuffer;
    ByteBuffer mappedBuffer = null;
    private final GL gl;
    long sizeInBytes;

    public static VBO createStaticVBO(GL gl, ByteBuffer buffer, long sizeInBytes) {
        if (gl.isGL2GL3()) {
            GL2GL3 gl23 = gl.getGL2GL3();
            GLError.check((GL)gl23);
            int[] vbos = new int[1];
            gl.glGenBuffers(1, vbos, 0);
            GLError.check((GL)gl23);
            gl23.glBindBuffer(34962, vbos[0]);
            GLError.check((GL)gl23);
            gl23.glBufferData(34962, sizeInBytes, (Buffer)buffer, 35044);
            GLError.check((GL)gl23);
            gl23.glBindBuffer(34962, 0);
            return new VBO(gl, vbos[0], null, sizeInBytes);
        }
        throw new RNDRException("unsupported GL implementation");
    }

    public static VBO createDynamicVBO(GL gl, ByteBuffer buffer, long sizeInBytes) {
        if (gl.isGL2GL3()) {
            GL2GL3 gl23 = gl.getGL2GL3();
            GLError.check((GL)gl23);
            int[] vbos = new int[1];
            gl.glGenBuffers(1, vbos, 0);
            GLError.check((GL)gl23);
            gl23.glBindBuffer(34962, vbos[0]);
            GLError.check((GL)gl23);
            gl23.glBufferData(34962, sizeInBytes, (Buffer)buffer, 35040);
            GLError.check((GL)gl23);
            return new VBO(gl, vbos[0], null, sizeInBytes);
        }
        throw new RNDRException("unsupported GL implementation");
    }

    public static VBO createMappedVBO(GL gl, int floats) {
        if (gl.isGL2GL3()) {
            GL2GL3 gl23 = gl.getGL2GL3();
            GLError.check((GL)gl23);
            int[] vbos = new int[1];
            gl.glGenBuffers(1, vbos, 0);
            GLError.check((GL)gl23);
            gl23.glBindBuffer(34962, vbos[0]);
            GLError.check((GL)gl23);
            gl23.glBufferData(34962, (long)(4 * floats), null, 35040);
            GLError.check((GL)gl23);
            return new VBO(gl, vbos[0], null, floats * 4);
        }
        throw new RNDRException("unsupported GL implementation");
    }

    private VBO(GL gl, int vbo, ByteBuffer dataBuffer, long sizeInBytes) {
        this.vbo = vbo;
        this.sourceBuffer = dataBuffer;
        this.gl = gl;
    }

    public VBO rewind() {
        if (this.sourceBuffer != null) {
            this.sourceBuffer.rewind();
        } else if (this.mappedBuffer != null) {
            this.mappedBuffer.rewind();
        }
        return this;
    }

    public VBO write(Object object) {
        throw new RuntimeException("not implemented");
    }

    public VBO write(Vector3 vector3) {
        if (this.mappedBuffer != null) {
            this.mappedBuffer.putFloat((float)vector3.x);
            this.mappedBuffer.putFloat((float)vector3.y);
            this.mappedBuffer.putFloat((float)vector3.z);
        }
        return this;
    }

    public VBO write(float x) {
        if (this.mappedBuffer != null) {
            this.mappedBuffer.putFloat(x);
        }
        return this;
    }

    public VBO write(float[] xs) {
        if (this.mappedBuffer != null) {
            for (float x : xs) {
                this.mappedBuffer.putFloat(x);
            }
        }
        return this;
    }

    public VBO write(double[] xs) {
        if (this.mappedBuffer != null) {
            for (double x : xs) {
                this.mappedBuffer.putFloat((float)x);
            }
        }
        return this;
    }

    public VBO write(double x, double y) {
        if (this.mappedBuffer != null) {
            this.mappedBuffer.putFloat((float)x);
            this.mappedBuffer.putFloat((float)y);
        }
        return this;
    }

    public VBO write(double x, double y, double z) {
        if (this.mappedBuffer != null) {
            this.mappedBuffer.putFloat((float)x);
            this.mappedBuffer.putFloat((float)y);
            this.mappedBuffer.putFloat((float)z);
        }
        return this;
    }

    public VBO write(double x, double y, double z, double w) {
        if (this.mappedBuffer != null) {
            this.mappedBuffer.putFloat((float)x);
            this.mappedBuffer.putFloat((float)y);
            this.mappedBuffer.putFloat((float)z);
            this.mappedBuffer.putFloat((float)w);
        }
        return this;
    }

    public VBO write(Color color) {
        if (this.mappedBuffer != null) {
            this.mappedBuffer.putFloat((float)color.r);
            this.mappedBuffer.putFloat((float)color.g);
            this.mappedBuffer.putFloat((float)color.b);
            this.mappedBuffer.putFloat((float)color.a);
        }
        return this;
    }

    public VBO write(Vector4 vector4) {
        if (this.mappedBuffer != null) {
            this.mappedBuffer.putFloat((float)vector4.x);
            this.mappedBuffer.putFloat((float)vector4.y);
            this.mappedBuffer.putFloat((float)vector4.z);
            this.mappedBuffer.putFloat((float)vector4.w);
        }
        return this;
    }

    public VBO write(Vector2 vector2) {
        if (this.mappedBuffer != null) {
            this.mappedBuffer.putFloat((float)vector2.x);
            this.mappedBuffer.putFloat((float)vector2.y);
        }
        return this;
    }

    public VBO bind() {
        this.gl.glBindBuffer(34962, this.vbo);
        return this;
    }

    public VBO unbind() {
        this.gl.glBindBuffer(34962, 0);
        return this;
    }

    public VBO map() {
        this.gl.glBindBuffer(34962, this.vbo);
        this.mappedBuffer = this.gl.glMapBuffer(34962, 35001);
        if (this.mappedBuffer == null) {
            throw new RuntimeException("vbo map failed");
        }
        return this;
    }

    public VBO unmap() {
        if (this.mappedBuffer != null) {
            this.gl.glBindBuffer(34962, this.vbo);
            this.mappedBuffer = null;
            this.gl.glUnmapBuffer(34962);
            return this;
        }
        throw new RuntimeException("vbo not mapped");
    }

    public VBO destroy() {
        this.gl.glDeleteBuffers(34962, new int[]{this.vbo}, 0);
        return this;
    }

    public ByteBuffer getMappedBuffer() {
        return this.mappedBuffer;
    }

    public void write(ByteBuffer data) {
        this.bind();
        this.gl.glBufferSubData(34962, 0L, (long)data.capacity(), (Buffer)data);
    }

    public void write(ByteBuffer data, int offset, int size) {
        this.bind();
        this.gl.glBufferSubData(34962, (long)offset, (long)size, (Buffer)data);
    }
}

