/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.rndr.vbo;

import java.util.HashSet;
import java.util.Set;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import javax.media.opengl.GL3;
import net.lustlab.rndr.shaders.Shader;
import net.lustlab.rndr.vbo.VAO;
import net.lustlab.rndr.vbo.VBO;
import net.lustlab.rndr.vbo.VBOItem;
import net.lustlab.rndr.vbo.VBOLayout;

public class VBODrawer {
    static Set<WarningInfo> issuedAttributeWarnings = new HashSet<WarningInfo>();

    public static void draw(GL3 gl, VAO vao, int primitive, int count) {
        vao.bind();
        gl.glDrawArrays(primitive, 0, count);
        vao.unbind();
    }

    public static void draw(GL gl, Shader shader, VBO vbo, VBOLayout layout, int primitive, int count) {
        if (gl.isGL2()) {
            if (vbo.mappedBuffer == null) {
                vbo.bind();
                VBODrawer.setupLayoutGL2(gl.getGL2(), layout, shader);
                gl.glDrawArrays(primitive, 0, count);
                VBODrawer.teardownLayoutGL2(gl.getGL2(), layout, shader);
            } else {
                throw new RuntimeException("VBO is still mapped");
            }
        }
        if (gl.isGL3()) {
            vbo.bind();
            VBODrawer.setupLayoutGL3(gl.getGL3(), layout, shader);
            gl.glDrawArrays(primitive, 0, count);
            VBODrawer.teardownLayoutGL3(gl.getGL3(), layout, shader);
        }
    }

    public static void drawInstances(GL gl, Shader shader, VBO vbo, VBOLayout layout, int primitive, int primitiveCount, int instanceCount) {
        if (!gl.isGL3()) {
            throw new RuntimeException("no GL3 context");
        }
        GL3 gl3 = gl.getGL3();
        VBODrawer.setupLayoutGL3(gl3, layout, shader);
        gl3.glDrawArraysInstanced(primitive, 0, primitiveCount, instanceCount);
        VBODrawer.teardownLayoutGL3(gl3, layout, shader);
    }

    public static void drawInstances(GL gl, VAO vao, int primitive, int primitiveCount, int instanceCount) {
        if (!gl.isGL3()) {
            throw new RuntimeException("no GL3 context");
        }
        GL3 gl3 = gl.getGL3();
        vao.bind();
        gl3.glDrawArraysInstanced(primitive, 0, primitiveCount, instanceCount);
        vao.unbind();
    }

    static void setupLayoutGL3(GL3 gl, VBOLayout layout, Shader shader) {
        for (VBOItem item : layout.items) {
            String attribute = item.attribute;
            switch (item.attribute) {
                case "gl_Normal": {
                    attribute = "normal";
                    break;
                }
                case "gl_Color": {
                    attribute = "color";
                    break;
                }
                case "gl_Vertex": {
                    attribute = "position";
                    break;
                }
                case "gl_MultiTexCoord0": 
                case "gl_MultiTexCoord1": 
                case "gl_MultiTexCoord2": 
                case "gl_MultiTexCoord3": 
                case "gl_MultiTexCoord4": 
                case "gl_MultiTexCoord5": 
                case "gl_MultiTexCoord6": 
                case "gl_MultiTexCoord7": {
                    int textureUnit = Integer.parseInt(item.attribute.substring(item.attribute.length() - 1));
                    attribute = "texCoord" + textureUnit;
                    break;
                }
            }
            int attributeIndex = shader.attributeIndex(attribute);
            if (attributeIndex != -1) {
                gl.glEnableVertexAttribArray(attributeIndex);
                gl.glVertexAttribPointer(attributeIndex, item.count, item.type, false, layout.vertexSize, (long)item.offset);
                continue;
            }
            WarningInfo wi = new WarningInfo(attribute, layout, shader);
            if (issuedAttributeWarnings.contains(wi)) continue;
            System.out.println("problem with attribute:" + attribute + " " + shader + " " + layout);
            issuedAttributeWarnings.add(wi);
        }
    }

    static void teardownLayoutGL3(GL3 gl, VBOLayout layout, Shader shader) {
        for (VBOItem item : layout.items) {
            int attributeIndex = shader.attributeIndex(item.attribute);
            if (attributeIndex == -1) continue;
            gl.glDisableVertexAttribArray(attributeIndex);
        }
    }

    static void setupLayoutGL2(GL2 gl, VBOLayout layout, Shader shader) {
        block19: for (VBOItem item : layout.items) {
            switch (item.attribute) {
                case "gl_Normal": {
                    gl.glEnableClientState(32885);
                    gl.glNormalPointer(item.type, layout.vertexSize, (long)item.offset);
                    continue block19;
                }
                case "gl_Color": {
                    gl.glEnableClientState(32886);
                    gl.glColorPointer(item.count, item.type, layout.vertexSize, (long)item.offset);
                    continue block19;
                }
                case "gl_Vertex": {
                    gl.glEnableClientState(32884);
                    gl.glVertexPointer(item.count, item.type, layout.vertexSize, (long)item.offset);
                    continue block19;
                }
                case "gl_MultiTexCoord0": 
                case "gl_MultiTexCoord1": 
                case "gl_MultiTexCoord2": 
                case "gl_MultiTexCoord3": 
                case "gl_MultiTexCoord4": 
                case "gl_MultiTexCoord5": 
                case "gl_MultiTexCoord6": 
                case "gl_MultiTexCoord7": {
                    int textureUnit = Integer.parseInt(item.attribute.substring(item.attribute.length() - 1));
                    gl.glClientActiveTexture(33984 + textureUnit);
                    gl.glEnableClientState(32888);
                    gl.glTexCoordPointer(item.count, item.type, layout.vertexSize, (long)item.offset);
                    gl.glClientActiveTexture(33984);
                    continue block19;
                }
            }
            int attributeIndex = shader.attributeIndex(item.attribute);
            if (attributeIndex == -1) continue;
            gl.glEnableVertexAttribArray(attributeIndex);
            gl.glVertexAttribPointer(attributeIndex, item.count, item.type, false, layout.vertexSize, (long)item.offset);
        }
    }

    static void teardownLayoutGL2(GL2 gl, VBOLayout layout, Shader shader) {
        block19: for (VBOItem item : layout.items) {
            switch (item.attribute) {
                case "gl_Normal": {
                    gl.glDisableClientState(32885);
                    continue block19;
                }
                case "gl_Color": {
                    gl.glDisableClientState(32886);
                    continue block19;
                }
                case "gl_Vertex": {
                    gl.glDisableClientState(32884);
                    continue block19;
                }
                case "gl_MultiTexCoord0": 
                case "gl_MultiTexCoord1": 
                case "gl_MultiTexCoord2": 
                case "gl_MultiTexCoord3": 
                case "gl_MultiTexCoord4": 
                case "gl_MultiTexCoord5": 
                case "gl_MultiTexCoord6": 
                case "gl_MultiTexCoord7": {
                    int textureUnit = Integer.parseInt(item.attribute.substring(item.attribute.length() - 1));
                    gl.glClientActiveTexture(33984 + textureUnit);
                    gl.glDisableClientState(32888);
                    gl.glClientActiveTexture(33984);
                    continue block19;
                }
            }
            int attributeIndex = shader.attributeIndex(item.attribute);
            gl.glDisableVertexAttribArray(attributeIndex);
        }
    }

    public static class WarningInfo {
        String attribute;
        VBOLayout layout;
        Shader shader;

        public WarningInfo(String attribute, VBOLayout layout, Shader shader) {
            this.attribute = attribute;
            this.layout = layout;
            this.shader = shader;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WarningInfo that = (WarningInfo)o;
            if (this.attribute != null ? !this.attribute.equals(that.attribute) : that.attribute != null) {
                return false;
            }
            if (this.layout != null ? !this.layout.equals(that.layout) : that.layout != null) {
                return false;
            }
            return !(this.shader != null ? !this.shader.equals(that.shader) : that.shader != null);
        }

        public int hashCode() {
            int result = this.attribute != null ? this.attribute.hashCode() : 0;
            result = 31 * result + (this.layout != null ? this.layout.hashCode() : 0);
            result = 31 * result + (this.shader != null ? this.shader.hashCode() : 0);
            return result;
        }
    }
}

