/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.rndr.vbo;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.lustlab.rndr.color.Color;
import net.lustlab.rndr.math.Vector2;
import net.lustlab.rndr.math.Vector3;
import net.lustlab.rndr.math.Vector4;
import net.lustlab.rndr.vbo.Attribute;
import net.lustlab.rndr.vbo.VBOItem;

public class VBOLayout {
    List<VBOItem> items = new ArrayList<VBOItem>();
    int vertexSize = 0;

    public static VBOLayout createForClass(Class type) {
        VBOLayout layout = new VBOLayout();
        for (Field field : type.getDeclaredFields()) {
            int dimensions;
            Attribute attribute = field.getAnnotation(Attribute.class);
            Attribute.Color color = field.getAnnotation(Attribute.Color.class);
            Attribute.Normal normal = field.getAnnotation(Attribute.Normal.class);
            Attribute.Position position = field.getAnnotation(Attribute.Position.class);
            Attribute.TextureCoord textureCoord = field.getAnnotation(Attribute.TextureCoord.class);
            if (position != null) {
                dimensions = VBOLayout.getDimensions(field, position.dimensions());
                layout.position(dimensions);
                continue;
            }
            if (normal != null) {
                dimensions = VBOLayout.getDimensions(field, 3);
                layout.position(dimensions);
                continue;
            }
            if (color != null) {
                dimensions = VBOLayout.getDimensions(field, color.dimensions());
                layout.position(dimensions);
                continue;
            }
            if (textureCoord == null) continue;
            dimensions = VBOLayout.getDimensions(field, textureCoord.dimensions());
            int index = textureCoord.index();
            layout.textureCoordinate(index, dimensions);
        }
        return layout;
    }

    public static int getDimensions(Field field, int dimensions) {
        if (field.getType().equals(Vector3.class)) {
            dimensions = 3;
        } else if (field.getType().equals(Vector2.class)) {
            dimensions = 2;
        } else if (field.getType().equals(Vector4.class)) {
            dimensions = 4;
        } else if (field.getType().equals(Color.class)) {
            dimensions = 4;
        } else if (field.getType().equals(Double.class)) {
            dimensions = 1;
        } else if (field.getType().equals(Float.class)) {
            dimensions = 1;
        } else if (field.getType().equals(Double.TYPE)) {
            dimensions = 1;
        } else if (field.getType().equals(Float.TYPE)) {
            dimensions = 1;
        }
        return dimensions;
    }

    public int size() {
        return this.vertexSize;
    }

    public VBOLayout position(int dimensions) {
        return this.attribute("gl_Vertex", dimensions, 5126);
    }

    public VBOLayout normal(int dimensions) {
        return this.attribute("gl_Normal", dimensions, 5126);
    }

    public VBOLayout color(int dimensions) {
        return this.attribute("gl_Color", dimensions, 5126);
    }

    public VBOLayout textureCoordinate(int index, int dimensions) {
        return this.attribute("gl_MultiTexCoord" + index, dimensions, 5126);
    }

    public VBOLayout textureCoordinate(int dimensions) {
        return this.textureCoordinate(0, dimensions);
    }

    static int size(int type) {
        switch (type) {
            case 5126: {
                return 4;
            }
        }
        throw new RuntimeException("unsupported element type: " + type);
    }

    public VBOLayout attribute(String name, int dimensions, int type) {
        VBOItem item = new VBOItem();
        item.attribute = name;
        item.size = dimensions * VBOLayout.size(type);
        int offset = 0;
        for (VBOItem i : this.items) {
            offset += i.size;
        }
        item.offset = offset;
        item.type = type;
        item.count = dimensions;
        this.items.add(item);
        this.vertexSize += item.size;
        return this;
    }

    public String toString() {
        return "VBOLayout{items=" + this.items + ", vertexSize=" + this.vertexSize + '}';
    }
}

