/*
 * Decompiled with CFR 0.152.
 */
package thimble.effects;

import framer.Animatable;
import framer.Easing;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.media.opengl.GL;
import javax.media.opengl.GL3;
import net.lustlab.rndr.color.Color;
import net.lustlab.rndr.draw.Composition;
import net.lustlab.rndr.draw.Contour;
import net.lustlab.rndr.draw.Shape;
import net.lustlab.rndr.font.FontMap;
import net.lustlab.rndr.font.image.FontImageMap;
import net.lustlab.rndr.font.image.FontImageMapManager;
import net.lustlab.rndr.math.Linear;
import net.lustlab.rndr.math.Matrix44;
import net.lustlab.rndr.math.Transforms;
import net.lustlab.rndr.math.Vector3;
import net.lustlab.rndr.svg.SVGDocument;
import net.lustlab.rndr.svg.SVGLoader;
import net.lustlab.rndr.text.Writer;
import org.yaml.snakeyaml.Yaml;
import thimble.effects.BezierSegmentsDrawer;
import thimble.effects.BezierSegmentsParameters;

public class BezierSegments {
    private Composition composition;
    FontImageMap font;
    BezierSegmentsParameters[] parameters;
    List<Contour> contours = new ArrayList<Contour>();
    List<List<Glyph>> glyphs = new ArrayList<List<Glyph>>();
    double[] randoms;
    int index = 0;
    BezierSegmentsDrawer drawer;
    GL3 gl3;

    public BezierSegments(GL3 gl3, int width, int height) {
        this.gl3 = gl3;
        this.font = FontImageMapManager.fontMap((String)"data/fonts/SourceCodePro-Medium.ttf", (int)18);
        Yaml yaml = new Yaml();
        try {
            this.parameters = (BezierSegmentsParameters[])yaml.loadAs((InputStream)new FileInputStream(new File("data/parameters/beziersegments.yaml")), BezierSegmentsParameters[].class);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        this.drawer = new BezierSegmentsDrawer(gl3, width, height);
        try {
            SVGDocument doc = SVGLoader.loadSVG((String)this.parameters[0].svg);
            this.composition = doc.composition();
        }
        catch (IOException e) {
            // empty catch block
        }
        this.randoms = new double[height];
        for (int i = 0; i < this.randoms.length; ++i) {
            this.randoms[i] = Math.random();
        }
        for (BezierSegmentsParameters.PathParameters pp : this.parameters[0].pathParameters) {
            this.initGlyphs(pp);
        }
    }

    static double uniform(double low, double high) {
        return Math.random() * (high - low) + low;
    }

    public void next() {
        this.contours.clear();
        this.glyphs.clear();
        this.index = (this.index + 1) % this.parameters.length;
        try {
            SVGDocument doc = SVGLoader.loadSVG((String)this.parameters[this.index].svg);
            this.composition = doc.composition();
        }
        catch (IOException e) {
            // empty catch block
        }
        for (BezierSegmentsParameters.PathParameters pp : this.parameters[this.index].pathParameters) {
            this.initGlyphs(pp);
        }
    }

    public void initGlyphs(BezierSegmentsParameters.PathParameters pathParameters) {
        long ct = System.currentTimeMillis();
        for (Shape shape : this.composition.shapes(pathParameters.pathRegex)) {
            for (Contour contour : shape) {
                ArrayList<Glyph> glyphs = new ArrayList<Glyph>();
                double offset = pathParameters.offsetLow;
                while (offset < pathParameters.offsetHigh) {
                    double weight = BezierSegments.uniform(pathParameters.weightLow, pathParameters.weightHigh);
                    offset += weight + BezierSegments.uniform(pathParameters.gapLow, pathParameters.gapHigh);
                    int duration = (int)BezierSegments.uniform(pathParameters.durationLow, pathParameters.durationHigh);
                    int columns = (int)BezierSegments.uniform(pathParameters.columnsLow, pathParameters.columnsHigh);
                    double spacing = 1.0 / (double)columns;
                    double jump = BezierSegments.uniform(pathParameters.jumpLow, pathParameters.jumpHigh);
                    double length = BezierSegments.uniform(pathParameters.lengthLow, pathParameters.lengthHigh);
                    int direction = (int)(Math.random() * 2.0);
                    int delay = (int)BezierSegments.uniform(pathParameters.delayLow, pathParameters.delayHigh);
                    int predelay = (int)BezierSegments.uniform(pathParameters.predelayLow, pathParameters.predelayHigh);
                    double prejump = BezierSegments.uniform(pathParameters.prejumpLow, pathParameters.prejumpHigh);
                    direction = direction == 0 ? -1 : 1;
                    for (int i = 0; i < columns; ++i) {
                        Glyph glyph = new Glyph();
                        glyph.updateAnimation(ct);
                        glyph.t = this.mod((double)i * spacing * (double)contour.segments.size() + prejump, contour.segments.size());
                        glyph.offset = offset;
                        glyph.length = 0.0;
                        int growDelay = (int)BezierSegments.uniform(pathParameters.growDelayLow, pathParameters.growDelayHigh);
                        glyph.delay(growDelay);
                        glyph.animate("length", length, (long)BezierSegments.uniform(pathParameters.growLow, pathParameters.growHigh));
                        glyph.delay(-growDelay);
                        glyph.weight = weight;
                        glyph.delay(i * predelay);
                        Easing easing = Easing.valueOf((String)pathParameters.jumpEasing);
                        for (int c = 0; c < 100; ++c) {
                            glyph.delay(delay).add("t", jump * (double)direction, (long)duration, easing).complete();
                        }
                        glyphs.add(glyph);
                    }
                }
                this.contours.add(contour);
                this.glyphs.add(glyphs);
            }
        }
    }

    private double mod(double v, double size) {
        return (v % size + size) % size;
    }

    public void draw(Matrix44 projection, double time) {
        for (int i = 0; i < this.contours.size(); ++i) {
            Contour contour = this.contours.get(i);
            List<Glyph> glyphs = this.glyphs.get(i);
            this.drawer.draw(projection, time, contour, glyphs);
        }
        Writer writer = new Writer((GL)this.gl3);
        writer.projection(projection);
        writer.modelView(Linear.multiply((Matrix44[])new Matrix44[]{Transforms.translate((Vector3)new Vector3(640.0, 360.0, 0.0)), Transforms.rotateZ((double)-1.5707963267948966), Transforms.translate((Vector3)new Vector3(-640.0, -360.0, 0.0))}));
        writer.font((FontMap)this.font);
        writer.fill(Color.BLACK);
        writer.cursor(640.0, -260.0);
        writer.text("CMP/" + this.index);
    }

    static class Glyph
    extends Animatable {
        double t;
        public double offset;
        public double length;
        public double weight;

        Glyph() {
        }
    }
}

