/*
 * Decompiled with CFR 0.152.
 */
package thimble.effects;

import java.util.ArrayList;
import javax.media.opengl.GL3;
import net.lustlab.rndr.color.Color;
import net.lustlab.rndr.math.Matrix44;
import thimble.effects.ca.Grid;
import thimble.effects.ca.GridDrawer;

public class Grids {
    Grid[] grids;
    GridDrawer gridDrawer;
    GL3 gl3;
    public double hotX;
    public double hotY;
    int width;
    int height;
    int[][] counts;

    public Grids(GL3 gl3, int width, int height) {
        this.width = width;
        this.height = height;
        this.gl3 = gl3;
        this.grids = new Grid[3];
        for (int i = 0; i < this.grids.length; ++i) {
            this.grids[i] = new Grid(width / 16, height / 16);
            this.grids[i].useAnimations = true;
        }
        this.gridDrawer = new GridDrawer(gl3, width, height);
        this.gridDrawer.useSliding = true;
        this.gridDrawer.useHatchings = true;
        this.gridDrawer.useFading = false;
        this.counts = new int[height / 16][width / 16];
    }

    public void draw(Matrix44 projection, Matrix44 view, double intensity) {
        this.gl3.glEnable(3042);
        this.gl3.glBlendFunc(770, 771);
        for (int i = 0; i < this.grids.length; ++i) {
            this.gridDrawer.color = Color.BLACK;
            this.grids[i].update();
            this.grids[i].useAnimations = true;
            this.gridDrawer.useSliding = true;
            this.gridDrawer.draw(projection, view, this.grids[i], intensity);
        }
        for (int y = 0; y < this.height / 16; ++y) {
            for (int x = 0; x < this.width / 16; ++x) {
                this.counts[y][x] = 0;
            }
        }
        int maxCount = Integer.MIN_VALUE;
        int maxy = -1;
        int maxx = -1;
        ArrayList<int[]> candidates = new ArrayList<int[]>();
        for (int i = 0; i < this.grids.length; ++i) {
            for (int y = 0; y < this.height / 16; ++y) {
                for (int x = 0; x < this.width / 16; ++x) {
                    for (int m = -1; m <= 1; ++m) {
                        for (int n = -1; n <= 1; ++n) {
                            int v = y + m;
                            int u = x + m;
                            if (u < 0 || v < 0 || u >= this.width / 16 || v >= this.height / 16 || !this.grids[i].cells[y][x].alive) continue;
                            int[] nArray = this.counts[y];
                            int n2 = x;
                            nArray[n2] = nArray[n2] + 1;
                            if (this.counts[y][x] > maxCount) {
                                candidates.clear();
                                candidates.add(new int[]{x, y});
                                maxCount = this.counts[y][x];
                                maxx = x;
                                maxy = y;
                                continue;
                            }
                            if (this.counts[y][x] != maxCount) continue;
                            candidates.add(new int[]{x, y});
                        }
                    }
                }
            }
        }
        int[] candidate = (int[])candidates.get((int)((double)candidates.size() * Math.random()));
        this.hotX = (double)candidate[0] / (double)(this.width / 16);
        this.hotY = (double)candidate[1] / (double)(this.height / 16);
    }
}

