/*
 * Decompiled with CFR 0.152.
 */
package thimble.effects;

import framer.Animatable;
import framer.Easing;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.media.opengl.GL3;
import net.lustlab.rndr.draw.Composition;
import net.lustlab.rndr.draw.Figure;
import net.lustlab.rndr.draw.Polygon;
import net.lustlab.rndr.draw.Tessellation;
import net.lustlab.rndr.draw.TessellationRendererGL3;
import net.lustlab.rndr.math.Matrix44;
import net.lustlab.rndr.math.Transform;
import net.lustlab.rndr.math.Transforms;
import net.lustlab.rndr.math.Vector3;
import net.lustlab.rndr.svg.SVGDocument;
import net.lustlab.rndr.svg.SVGLoader;

public class Logo {
    Composition composition;
    Figure figure;
    Tessellation tessellation;
    List<Polygon> stripes;
    List<AnimatablePolygon> animatableStripes = new ArrayList<AnimatablePolygon>();
    GL3 gl3;

    public Logo(GL3 gl3) {
        this.gl3 = gl3;
        try {
            SVGDocument doc = SVGLoader.loadSVG((String)"data/paths/logo.svg");
            this.composition = doc.composition();
            this.figure = this.composition.figure();
            this.stripes = this.figure.polygons("stripe-.");
            int i = 0;
            for (Polygon stripe : this.stripes) {
                AnimatablePolygon ap = new AnimatablePolygon();
                ap.polygon = stripe;
                ap.x = 1000.0;
                ap.y = 1000.0;
                ap.scale = 1.0;
                ap.updateAnimation();
                ap.delay(i * 500 + 1000).animate("x", 0.0, 3000L, Easing.CubicInOut).animate("y", 0.0, 3000L, Easing.CubicInOut).complete().delay(3000L).animate("x", -2000.0, 4000L, Easing.CubicInOut).animate("y", -2000.0, 4000L, Easing.CubicInOut);
                ++i;
                this.animatableStripes.add(ap);
            }
            this.tessellation = Tessellation.tessellate((Figure)this.figure);
        }
        catch (IOException e) {
            throw new RuntimeException("failed to load logo");
        }
    }

    public void draw(Matrix44 projection, Matrix44 view) {
        for (AnimatablePolygon as : this.animatableStripes) {
            as.updateAnimation();
            as.polygon.transform = new Transform(Transforms.translate((Vector3)new Vector3(as.x, as.y, 0.0)));
        }
        TessellationRendererGL3.drawTessellation((GL3)this.gl3, (Matrix44)projection, (Matrix44)view, (Tessellation)this.tessellation);
    }

    public static class AnimatablePolygon
    extends Animatable {
        Polygon polygon;
        double x;
        double y;
        double scale;
    }
}

