/*
 * Decompiled with CFR 0.152.
 */
package thimble.effects;

import java.io.InputStream;
import java.nio.ByteBuffer;
import javax.media.opengl.GL;
import javax.media.opengl.GL3;
import net.lustlab.rndr.math.Linear;
import net.lustlab.rndr.math.Matrix44;
import net.lustlab.rndr.math.Transforms;
import net.lustlab.rndr.math.Vector2;
import net.lustlab.rndr.math.Vector3;
import net.lustlab.rndr.shaders.FragmentShader;
import net.lustlab.rndr.shaders.Shader;
import net.lustlab.rndr.shaders.VertexShader;
import net.lustlab.rndr.vbo.BufferWriter;
import net.lustlab.rndr.vbo.VBO;
import net.lustlab.rndr.vbo.VBODrawer;
import net.lustlab.rndr.vbo.VBOLayout;

public class ParticleSwarm {
    GL3 gl3;
    VBO particle;
    VBOLayout layout;
    Shader shader;

    public ParticleSwarm(GL3 gl3) {
        this.gl3 = gl3;
        this.layout = new VBOLayout().textureCoordinate(2).position(3);
        ByteBuffer buffer = ByteBuffer.allocateDirect(this.layout.size() * 6);
        BufferWriter bw = new BufferWriter(buffer);
        double w = 0.01;
        double h = 0.01;
        Vector3 p00 = new Vector3(-w, h, 0.0);
        Vector3 p10 = new Vector3(w, h, 0.0);
        Vector3 p11 = new Vector3(w, -h, 0.0);
        Vector3 p01 = new Vector3(-w, -h, 0.0);
        Vector2 t00 = new Vector2(0.0, 0.0);
        Vector2 t10 = new Vector2(1.0, 0.0);
        Vector2 t11 = new Vector2(1.0, 1.0);
        Vector2 t01 = new Vector2(0.0, 1.0);
        bw.write(t00).write(p00).write(t10).write(p10).write(t11).write(p11);
        bw.write(t00).write(p00).write(t01).write(p01).write(t11).write(p11);
        buffer.rewind();
        this.particle = VBO.createStaticVBO((GL)gl3, (ByteBuffer)buffer, (long)(this.layout.size() * 6));
        this.shader = Shader.createShader((GL)gl3, (VertexShader)VertexShader.load((GL)gl3, (InputStream)this.getClass().getResourceAsStream("/shaders/particleswarm/particleswarm.vert")), (FragmentShader)FragmentShader.load((GL)gl3, (InputStream)this.getClass().getResourceAsStream("/shaders/particleswarm/particleswarm.frag")));
    }

    public void draw(Matrix44 projection, Matrix44 modelView, double time) {
        this.gl3.glDisable(2929);
        this.gl3.glEnable(3042);
        this.gl3.glBlendFunc(1, 1);
        this.shader.begin();
        this.shader.setUniform("modelViewProjectionMatrix", Linear.multiply((Matrix44[])new Matrix44[]{projection, modelView}).transpose());
        this.shader.setUniform("projectionMatrix", projection.transpose());
        this.shader.setUniform("modelViewMatrix", modelView.transpose());
        this.shader.setUniform("normalMatrix", Transforms.normal((Matrix44)modelView).transpose());
        this.shader.setUniform1f("time", (float)time);
        this.particle.bind();
        VBODrawer.drawInstances((GL)this.gl3, (Shader)this.shader, (VBO)this.particle, (VBOLayout)this.layout, (int)4, (int)6, (int)60000);
        this.particle.unbind();
        this.shader.end();
        this.gl3.glEnable(2929);
        this.gl3.glDisable(3042);
    }
}

