/*
 * Decompiled with CFR 0.152.
 */
package thimble.effects;

import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import javax.media.opengl.GL;
import javax.media.opengl.GL3;
import net.lustlab.rndr.image.BufferTexture;
import net.lustlab.rndr.math.Matrix44;
import net.lustlab.rndr.math.Vector2;
import net.lustlab.rndr.math.Vector4;
import net.lustlab.rndr.shaders.FragmentShader;
import net.lustlab.rndr.shaders.Shader;
import net.lustlab.rndr.shaders.VertexShader;
import net.lustlab.rndr.vbo.BufferWriter;
import net.lustlab.rndr.vbo.VAO;
import net.lustlab.rndr.vbo.VBO;
import net.lustlab.rndr.vbo.VBODrawer;
import net.lustlab.rndr.vbo.VBOLayout;
import thimble.effects.Dazzle;

public class PathDazzleDrawer {
    ByteBuffer positionsBuffer;
    VBO quad;
    VAO quadVAO;
    BufferTexture[] positions;
    VBOLayout layout;
    Shader shader;
    long bufferIndex = 0L;
    GL3 gl3;
    double patternFrequency = Math.PI * 5;
    double smoothing = 1.25;

    public PathDazzleDrawer(GL3 gl3) {
        this.gl3 = gl3;
        this.shader = Shader.createShader((GL)gl3, (VertexShader)VertexShader.load((GL)gl3, (InputStream)this.getClass().getResourceAsStream("/shaders/dazzler/dazzler.vert")), (FragmentShader)FragmentShader.load((GL)gl3, (InputStream)this.getClass().getResourceAsStream("/shaders/dazzler/dazzler.frag")));
        this.layout = new VBOLayout().color(4).textureCoordinate(2).position(2);
        ByteBuffer bb = ByteBuffer.allocateDirect(6 * this.layout.size());
        BufferWriter bw = new BufferWriter(bb);
        double lis = 0.0;
        double ris = 1.0;
        Vector2 uv00 = new Vector2(lis, 1.0);
        Vector2 uv01 = new Vector2(lis, 0.0);
        Vector2 uv11 = new Vector2(ris, 0.0);
        Vector2 uv10 = new Vector2(ris, 1.0);
        Vector2 p00 = new Vector2(lis - 0.5, -0.5);
        Vector2 p01 = new Vector2(lis - 0.5, 0.5);
        Vector2 p11 = new Vector2(ris - 0.5, 0.5);
        Vector2 p10 = new Vector2(ris - 0.5, -0.5);
        Vector4 f = new Vector4();
        bw.write(f).write(uv00).write(p00).write(f).write(uv01).write(p01).write(f).write(uv11).write(p11);
        bw.write(f).write(uv11).write(p11).write(f).write(uv10).write(p10).write(f).write(uv00).write(p00);
        this.positionsBuffer = ByteBuffer.allocateDirect(0x177000).order(ByteOrder.nativeOrder());
        this.positions = new BufferTexture[3];
        for (int i = 0; i < this.positions.length; ++i) {
            this.positions[i] = BufferTexture.createStream((GL3)gl3, (ByteBuffer)this.positionsBuffer, (int)0x177000, (int)34836);
        }
        bb.rewind();
        this.quad = VBO.createStaticVBO((GL)gl3, (ByteBuffer)bb, (long)bb.remaining());
        this.quadVAO = VAO.createVAO((GL3)gl3, (VBO)this.quad, (VBOLayout)this.layout, (Shader)this.shader);
    }

    public void draw(Matrix44 projection, Matrix44 view, List<Dazzle> dazzles, double intensity) {
        this.gl3.glEnable(3042);
        this.gl3.glBlendFunc(770, 771);
        BufferWriter bw = new BufferWriter(this.positionsBuffer);
        this.positionsBuffer.rewind();
        for (Dazzle dazzle : dazzles) {
            dazzle.updateAnimation();
            bw.write(dazzle.x, dazzle.y, dazzle.rotation, dazzle.scale);
        }
        this.positionsBuffer.rewind();
        int bi = (int)(this.bufferIndex % (long)this.positions.length);
        this.positions[bi].write(this.gl3, this.positionsBuffer);
        this.shader.begin();
        this.positions[bi].bindTexture();
        this.shader.setUniform("modelViewProjectionMatrix", projection.multiply(view).transpose());
        this.shader.setUniform1i("positions", 0);
        this.shader.setUniform1f("patternFrequency", (float)this.patternFrequency);
        this.shader.setUniform1f("smoothing", (float)this.smoothing);
        this.shader.setUniform1f("intensity", (float)intensity);
        VBODrawer.drawInstances((GL)this.gl3, (VAO)this.quadVAO, (int)4, (int)6, (int)dazzles.size());
        this.positions[bi].unbindTexture();
        this.shader.end();
        this.gl3.glDisable(3042);
        ++this.bufferIndex;
    }
}

