/*
 * Decompiled with CFR 0.152.
 */
package thimble.effects;

import java.io.InputStream;
import java.nio.ByteBuffer;
import javax.media.opengl.GL;
import javax.media.opengl.GL3;
import net.lustlab.rndr.image.Image;
import net.lustlab.rndr.image.ImageLoader;
import net.lustlab.rndr.math.Matrix44;
import net.lustlab.rndr.math.Transforms;
import net.lustlab.rndr.math.Vector3;
import net.lustlab.rndr.shaders.FragmentShader;
import net.lustlab.rndr.shaders.Shader;
import net.lustlab.rndr.shaders.VertexShader;
import net.lustlab.rndr.vbo.BufferWriter;
import net.lustlab.rndr.vbo.VBO;
import net.lustlab.rndr.vbo.VBODrawer;
import net.lustlab.rndr.vbo.VBOLayout;

public class Rider {
    int ride = 0;
    VBOLayout layout;
    VBO sphere;
    Shader shader;
    Image last;
    int sides = 12;
    int segments = 12;
    Image noise;
    GL3 gl3;
    ImageLoader loader;

    public void next() {
        this.ride = (this.ride + 1) % 4;
    }

    void generateSphere(ByteBuffer buffer, int instance, int M, int N, double r, double x, double y, double z, double rot) {
        BufferWriter bw = new BufferWriter(buffer);
        double u = 0.0;
        double v = 0.0;
        for (int m = 0; m < M; ++m) {
            for (int n = 0; n < N; ++n) {
                double lm0 = (double)m / (double)M;
                double ln0 = (double)n / (double)N;
                double lm1 = (double)(m + 1) / (double)M;
                double ln1 = (double)(n + 1) / (double)N;
                double x00 = x + Math.sin(Math.PI * lm0) * Math.cos(rot + Math.PI * 2 * ln0) * r;
                double z00 = z + Math.sin(Math.PI * lm0) * Math.sin(rot + Math.PI * 2 * ln0) * r;
                double y00 = y + Math.cos(Math.PI * lm0) * r;
                double x10 = x + Math.sin(Math.PI * lm1) * Math.cos(rot + Math.PI * 2 * ln0) * r;
                double z10 = z + Math.sin(Math.PI * lm1) * Math.sin(rot + Math.PI * 2 * ln0) * r;
                double y10 = y + Math.cos(Math.PI * lm1) * r;
                double x01 = x + Math.sin(Math.PI * lm0) * Math.cos(rot + Math.PI * 2 * ln1) * r;
                double z01 = z + Math.sin(Math.PI * lm0) * Math.sin(rot + Math.PI * 2 * ln1) * r;
                double y01 = y + Math.cos(Math.PI * lm0) * r;
                double x11 = x + Math.sin(Math.PI * lm1) * Math.cos(rot + Math.PI * 2 * ln1) * r;
                double z11 = z + Math.sin(Math.PI * lm1) * Math.sin(rot + Math.PI * 2 * ln1) * r;
                double y11 = y + Math.cos(Math.PI * lm1) * r;
                double cx = (x00 + x10 + x01 + x11) / 4.0;
                double cy = (y00 + y10 + y01 + y11) / 4.0;
                double cz = (z00 + z10 + z01 + z11) / 4.0;
                Vector3 normal = new Vector3(cx, cy, cz).normalized();
                double div = 1.0;
                bw.write(x00, y00, z00);
                bw.write(u + ln0 / div, v + lm0 / div);
                bw.write(x00, y00, z00);
                bw.write(x10, y10, z10);
                bw.write(u + ln0 / div, v + lm1 / div);
                bw.write(x10, y10, z10);
                bw.write(x11, y11, z11);
                bw.write(u + ln1 / div, v + lm1 / div);
                bw.write(x11, y11, z11);
                bw.write(x11, y11, z11);
                bw.write(u + ln1 / div, v + lm1 / div);
                bw.write(x11, y11, z11);
                bw.write(x00, y00, z00);
                bw.write(u + ln0 / div, v + lm0 / div);
                bw.write(x00, y00, z00);
                bw.write(x01, y01, z01);
                bw.write(u + ln1 / div, v + lm0 / div);
                bw.write(x01, y01, z01);
            }
        }
    }

    public Rider(GL3 gl3, ImageLoader loader, int width, int height) {
        this.gl3 = gl3;
        this.loader = loader;
        this.noise = Image.drawable((GL)gl3, (int)width, (int)height);
        this.layout = new VBOLayout().normal(3).textureCoordinate(2).position(3);
        ByteBuffer sphereBB = ByteBuffer.allocateDirect(this.layout.size() * this.sides * this.segments * 6);
        this.generateSphere(sphereBB, 0, this.sides, this.segments, 1.0, 0.0, 0.0, 0.0, 0.0);
        sphereBB.rewind();
        this.sphere = VBO.createStaticVBO((GL)gl3, (ByteBuffer)sphereBB, (long)sphereBB.capacity());
        this.shader = Shader.createShader((GL)gl3, (VertexShader)VertexShader.load((GL)gl3, (InputStream)this.getClass().getResourceAsStream("/shaders/rider/rider.vert")), (FragmentShader)FragmentShader.load((GL)gl3, (InputStream)this.getClass().getResourceAsStream("/shaders/rider/rider.frag")));
    }

    public void preload() {
        for (int set = 0; set < 4; ++set) {
            int total = 19;
            if (set == 0) {
                total = 12;
            }
            for (int entry = 0; entry < total; ++entry) {
                Image image = this.loader.getImage("data/images/rides/" + (set + 1) + "/" + String.format("%03d", entry + 1) + ".jpg");
                image.touch();
                image.unloadable = false;
                if (image.getState() != Image.State.NotLoaded) continue;
                this.loader.queue(image);
            }
        }
    }

    public void draw(Matrix44 projection, Matrix44 view, double time, double intensity) {
        int count = 19;
        if (this.ride == 0) {
            count = 12;
        }
        int index = (int)(time * 10.0) % count;
        Image image = this.loader.getImage("data/images/rides/" + (this.ride + 1) + "/" + String.format("%03d", index + 1) + ".jpg");
        image.touch();
        image.unloadable = false;
        if (image.getState() == Image.State.NotLoaded) {
            this.loader.queue(image);
        }
        this.shader.begin();
        this.shader.setUniform("modelViewProjectionMatrix", projection.multiply(view).transpose());
        this.shader.setUniform("modelViewMatrix", view.transpose());
        this.shader.setUniform("normalMatrix", Transforms.normal((Matrix44)view).transpose());
        this.shader.setUniform1f("time", (float)time);
        this.shader.setUniform1f("intensity", (float)intensity);
        this.sphere.bind();
        if (image.getState() == Image.State.Loaded) {
            image.texture.bind((GL)this.gl3);
            this.gl3.glTexParameteri(3553, 10242, 10497);
            this.gl3.glTexParameteri(3553, 10243, 10497);
            this.last = image;
        } else if (this.last != null && this.last.getState() == Image.State.Loaded) {
            this.last.texture.bind((GL)this.gl3);
            this.gl3.glTexParameteri(3553, 10242, 10497);
            this.gl3.glTexParameteri(3553, 10243, 10497);
        }
        VBODrawer.draw((GL)this.gl3, (Shader)this.shader, (VBO)this.sphere, (VBOLayout)this.layout, (int)4, (int)(this.sides * this.segments * 6));
        this.sphere.unbind();
        this.gl3.glBindTexture(3553, 0);
        this.shader.end();
    }
}

