/*
 * Decompiled with CFR 0.152.
 */
package thimble.effects.ca;

import framer.Animatable;
import framer.Easing;

public class Grid {
    int width;
    int height;
    long lastUpdate = -1L;
    public boolean useAnimations;
    public Cell[][] cells;

    public Grid(int width, int height) {
        this.width = width;
        this.height = height;
        this.cells = new Cell[height][width];
        this.initializeCells();
    }

    public void initializeCells() {
        double density = Math.random() * 0.25;
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                this.cells[y][x] = new Cell();
                this.cells[y][x].updateAnimation();
                if (Math.random() < density) {
                    this.cells[y][x].populate(this.useAnimations);
                } else {
                    this.cells[y][x].alive = false;
                    this.cells[y][x].stage("dead");
                }
                this.cells[y][x].x = x;
                this.cells[y][x].y = y;
                this.cells[y][x].fill = 0.0;
            }
        }
    }

    public void update() {
        int x;
        int y;
        int[][] counts = new int[this.height][this.width];
        int[][] majorityDirections = new int[this.height][this.width];
        for (int y2 = 0; y2 < this.height; ++y2) {
            for (int x2 = 0; x2 < this.width; ++x2) {
                counts[y2][x2] = 0;
            }
        }
        long ct = System.currentTimeMillis();
        long dt = ct - this.lastUpdate;
        if (dt > 200L) {
            this.lastUpdate = ct;
        }
        int[] directionCounts = new int[16];
        for (y = 0; y < this.height; ++y) {
            for (x = 0; x < this.width; ++x) {
                for (int i = 0; i < directionCounts.length; ++i) {
                    directionCounts[i] = 0;
                }
                for (int j = -1; j <= 1; ++j) {
                    for (int i = -1; i <= 1; ++i) {
                        if (i == 0 && j == 0) continue;
                        int v = y + j;
                        int u = x + i;
                        if (u <= 0 || v <= 0 || u >= this.width || v >= this.height || !this.cells[v][u].alive) continue;
                        int[] nArray = counts[y];
                        int n = x;
                        nArray[n] = nArray[n] + 1;
                        int n2 = this.cells[v][u].dir;
                        directionCounts[n2] = directionCounts[n2] + 1;
                    }
                }
                int max = 0;
                int maxArg = -1;
                for (int i = 0; i < directionCounts.length; ++i) {
                    if (directionCounts[i] <= max) continue;
                    max = directionCounts[i];
                    maxArg = i;
                }
                majorityDirections[y][x] = maxArg;
            }
        }
        for (y = 0; y < this.height; ++y) {
            for (x = 0; x < this.width; ++x) {
                int majorityDirection = majorityDirections[y][x];
                if (majorityDirection == -1) {
                    majorityDirection = (int)(Math.random() * 16.0);
                } else if (Math.random() < 0.1) {
                    majorityDirection = (int)(Math.random() * 16.0);
                }
                this.cells[y][x].updateAnimation(ct);
                if (dt <= 200L) continue;
                int alive = counts[y][x];
                if (this.cells[y][x].alive) {
                    if (alive >= 2 && alive <= 3) continue;
                    this.cells[y][x].die(this.useAnimations);
                    continue;
                }
                if (alive == 3) {
                    this.cells[y][x].populate(this.useAnimations);
                    this.cells[y][x].dir = majorityDirection;
                    continue;
                }
                if (!(Math.random() < 0.001)) continue;
                this.cells[y][x].populate(this.useAnimations);
                this.cells[y][x].dir = majorityDirection;
            }
        }
    }

    public static class Cell
    extends Animatable {
        double fill;
        double x;
        double y;
        int dir = (int)(Math.random() * 16.0);
        public boolean alive;

        public void populate(boolean animate) {
            this.alive = true;
            this.dir = (int)(Math.random() * 16.0);
            if (animate) {
                this.cancel().stage("alive").delay((long)(Math.random() * 40.0)).animate("fill", 1.0, (long)(500.0 + 160.0 * Math.random()), Easing.CubicInOut);
            } else {
                this.cancel().stage("alive").animate("fill", 1.0, 0L);
            }
        }

        public void die(boolean animate) {
            this.alive = false;
            if (animate) {
                this.cancel().stage("dead").delay((long)(Math.random() * 40.0)).animate("fill", 0.0, (long)(700.0 + 460.0 * Math.random()), Easing.CubicInOut);
            } else {
                this.cancel().stage("alive").animate("fill", 0.0, 0L);
            }
        }
    }
}

