/*
 * Decompiled with CFR 0.152.
 */
package thimble.post;

import framer.Animatable;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.media.opengl.GL;
import javax.media.opengl.GL3;
import net.lustlab.rndr.fbo.ColorBuffer;
import net.lustlab.rndr.fbo.RenderTarget;
import net.lustlab.rndr.math.Matrix44;
import net.lustlab.rndr.math.Transforms;
import net.lustlab.rndr.math.Vector2;
import net.lustlab.rndr.math.Vector3;
import net.lustlab.rndr.shaders.FragmentShader;
import net.lustlab.rndr.shaders.Shader;
import net.lustlab.rndr.shaders.VertexShader;
import net.lustlab.rndr.vbo.BufferWriter;
import net.lustlab.rndr.vbo.VBO;
import net.lustlab.rndr.vbo.VBODrawer;
import net.lustlab.rndr.vbo.VBOLayout;

public class Cutter {
    List<Cut> cuts = new ArrayList<Cut>();
    VBO quad;
    VBOLayout layout;
    Shader shader;
    int width;
    int height;
    GL3 gl3;

    public void randomizeCuts(boolean randomYoffs) {
        double x = 0.0;
        for (Cut cut : this.cuts) {
            double newWidth = Math.random() * 400.0;
            cut.animate("width", newWidth, 1000L);
            cut.animate("x", x, 1000L);
            cut.animate("sourceX", Math.max(0.0, x - Math.random() * 200.0), 1000L);
            if (randomYoffs) {
                cut.add("yoff", (Math.random() - 0.5) * 0.5, 1000L);
            }
            x += newWidth;
        }
    }

    public void initCuts() {
        double x = 0.0;
        this.cuts.clear();
        for (int i = 0; i < 15; ++i) {
            Cut cut = new Cut();
            cut.width = Math.random() * 360.0 + 40.0;
            cut.height = this.height;
            cut.x = x;
            cut.y = 0.0;
            cut.sourceX = Math.max(0.0, x - Math.random() * 200.0);
            cut.sourceY = 0.0;
            this.cuts.add(cut);
            x += cut.width;
        }
    }

    public Cutter(GL3 gl3, int width, int height) {
        this.width = width;
        this.height = height;
        this.gl3 = gl3;
        this.initCuts();
        this.shader = Shader.createShader((GL)gl3, (VertexShader)VertexShader.load((GL)gl3, (InputStream)this.getClass().getResourceAsStream("/shaders/cutter/cutter.vert")), (FragmentShader)FragmentShader.load((GL)gl3, (InputStream)this.getClass().getResourceAsStream("/shaders/cutter/cutter.frag")));
        this.layout = new VBOLayout().textureCoordinate(2).position(3);
        ByteBuffer buffer = ByteBuffer.allocateDirect(this.layout.size() * 6);
        BufferWriter bw = new BufferWriter(buffer);
        boolean w = true;
        boolean h = true;
        Vector3 p00 = new Vector3(0.0, 0.0, 0.0);
        Vector3 p10 = new Vector3((double)w, 0.0, 0.0);
        Vector3 p11 = new Vector3((double)w, (double)h, 0.0);
        Vector3 p01 = new Vector3(0.0, (double)h, 0.0);
        Vector2 t00 = new Vector2(0.0, 1.0);
        Vector2 t10 = new Vector2(1.0, 1.0);
        Vector2 t11 = new Vector2(1.0, 0.0);
        Vector2 t01 = new Vector2(0.0, 0.0);
        bw.write(t11).write(p11).write(t10).write(p10).write(t00).write(p00);
        bw.write(t00).write(p00).write(t01).write(p01).write(t11).write(p11);
        buffer.rewind();
        this.quad = VBO.createStaticVBO((GL)gl3, (ByteBuffer)buffer, (long)(this.layout.size() * 6));
    }

    public void draw(Matrix44 projection, Matrix44 view, ColorBuffer input, RenderTarget target, double yoff) {
        projection = Transforms.ortho((double)0.0, (double)this.width, (double)this.height, (double)0.0, (double)-1.0, (double)1.0);
        if (target != null) {
            target.bindTarget();
        }
        input.bindTexture((GL)this.gl3);
        this.gl3.glTexParameteri(3553, 10242, 10497);
        this.gl3.glTexParameteri(3553, 10243, 10497);
        this.shader.begin();
        this.shader.setUniform("modelViewProjectionMatrix", projection.multiply(view).transpose());
        this.shader.setUniform("extraOffset", new Vector2(0.0, yoff));
        this.quad.bind();
        this.quad.unbind();
        for (Cut cut : this.cuts) {
            cut.updateAnimation();
            this.shader.setUniform("offset", new Vector2(cut.x, cut.y));
            this.shader.setUniform("sourceOffset", new Vector2(cut.sourceX / 1280.0, cut.sourceY / 720.0));
            this.shader.setUniform("dimensions", new Vector2(cut.width, cut.height));
            this.shader.setUniform("extraOffset", new Vector2(0.0, yoff + cut.yoff));
            VBODrawer.draw((GL)this.gl3, (Shader)this.shader, (VBO)this.quad, (VBOLayout)this.layout, (int)4, (int)6);
        }
        this.shader.end();
        this.gl3.glBindTexture(3553, 0);
        if (target != null) {
            target.unbindTarget();
        }
    }

    public static class Cut
    extends Animatable {
        double x;
        double y;
        double width;
        double height;
        double sourceX;
        double sourceY;
        double yoff;
    }
}

