/*
 * Decompiled with CFR 0.152.
 */
package thimble.post;

import java.io.InputStream;
import java.nio.ByteBuffer;
import javax.media.opengl.GL;
import javax.media.opengl.GL3;
import net.lustlab.rndr.color.Color;
import net.lustlab.rndr.fbo.ColorBuffer;
import net.lustlab.rndr.fbo.RenderTarget;
import net.lustlab.rndr.image.Image;
import net.lustlab.rndr.math.Matrix44;
import net.lustlab.rndr.math.Vector2;
import net.lustlab.rndr.math.Vector3;
import net.lustlab.rndr.math.Vector4;
import net.lustlab.rndr.shaders.FragmentShader;
import net.lustlab.rndr.shaders.Shader;
import net.lustlab.rndr.shaders.VertexShader;
import net.lustlab.rndr.vbo.BufferWriter;
import net.lustlab.rndr.vbo.VAO;
import net.lustlab.rndr.vbo.VBO;
import net.lustlab.rndr.vbo.VBODrawer;
import net.lustlab.rndr.vbo.VBOLayout;

public class SSAO {
    VBO vbo;
    VBOLayout layout;
    VAO vao;
    Shader shader;
    Shader blurShader;
    Shader combineShader;
    int width;
    int height;
    RenderTarget intermediate;
    ColorBuffer intermediateColors;
    RenderTarget[] blur;
    ColorBuffer[] blurColors;
    Image noiseImage;
    Vector4[] poissonSamples;
    GL3 gl3;

    public SSAO(GL3 gl3, int width, int height) {
        this.gl3 = gl3;
        this.width = width;
        this.height = height;
        this.blur = new RenderTarget[2];
        this.blurColors = new ColorBuffer[2];
        this.intermediate = RenderTarget.create((GL)gl3, (int)(width / 2), (int)(height / 2));
        this.intermediateColors = ColorBuffer.create((GL)gl3, (int)(width / 2), (int)(height / 2));
        this.intermediate.attach(this.intermediateColors).unbindTarget();
        for (int i = 0; i < 2; ++i) {
            this.blur[i] = RenderTarget.create((GL)gl3, (int)width, (int)height);
            this.blurColors[i] = ColorBuffer.create((GL)gl3, (int)width, (int)height);
            this.blur[i].attach(this.blurColors[i]).unbindTarget();
        }
        this.noiseImage = Image.drawable((GL)gl3, (int)width, (int)height);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                this.noiseImage.write(x, y, new Color(Math.random(), Math.random(), 0.0, 0.0));
            }
        }
        this.noiseImage.upload();
        this.shader = Shader.createShader((GL)gl3, (VertexShader)VertexShader.load((GL)gl3, (InputStream)this.getClass().getResourceAsStream("/shaders/ssao/ssao.vert")), (FragmentShader)FragmentShader.load((GL)gl3, (InputStream)this.getClass().getResourceAsStream("/shaders/ssao/ssao.frag")));
        this.blurShader = Shader.createShader((GL)gl3, (VertexShader)VertexShader.load((GL)gl3, (InputStream)this.getClass().getResourceAsStream("/shaders/ssao/blur.vert")), (FragmentShader)FragmentShader.load((GL)gl3, (InputStream)this.getClass().getResourceAsStream("/shaders/ssao/blur.frag")));
        this.combineShader = Shader.createShader((GL)gl3, (VertexShader)VertexShader.load((GL)gl3, (InputStream)this.getClass().getResourceAsStream("/shaders/ssao/combine.vert")), (FragmentShader)FragmentShader.load((GL)gl3, (InputStream)this.getClass().getResourceAsStream("/shaders/ssao/combine.frag")));
        this.layout = new VBOLayout().attribute("eyeDir", 3, 5126).textureCoordinate(2).position(3);
        ByteBuffer bb = ByteBuffer.allocateDirect(this.layout.size() * 6);
        BufferWriter bw = new BufferWriter(bb);
        double ar = (double)width / (double)height;
        Vector3 ep00 = new Vector3(-ar, 1.0, 1.0);
        Vector3 ep10 = new Vector3(ar, 1.0, 1.0);
        Vector3 ep11 = new Vector3(ar, -1.0, 1.0);
        Vector3 ep01 = new Vector3(-ar, -1.0, 1.0);
        Vector2 uv00 = new Vector2(0.0, 1.0);
        Vector2 uv10 = new Vector2(1.0, 1.0);
        Vector2 uv11 = new Vector2(1.0, 0.0);
        Vector2 uv01 = new Vector2(0.0, 0.0);
        Vector3 p00 = new Vector3(0.0, 0.0, 0.0);
        Vector3 p10 = new Vector3((double)width, 0.0, 0.0);
        Vector3 p11 = new Vector3((double)width, (double)height, 0.0);
        Vector3 p01 = new Vector3(0.0, (double)height, 0.0);
        bw.write(ep11).write(uv11).write(p11);
        bw.write(ep10).write(uv10).write(p10);
        bw.write(ep00).write(uv00).write(p00);
        bw.write(ep00).write(uv00).write(p00);
        bw.write(ep01).write(uv01).write(p01);
        bw.write(ep11).write(uv11).write(p11);
        bb.rewind();
        this.vbo = VBO.createStaticVBO((GL)gl3, (ByteBuffer)bb, (long)(this.layout.size() * 6));
        this.vao = VAO.createVAO((GL3)gl3, (VBO)this.vbo, (VBOLayout)this.layout, (Shader)this.shader);
        this.poissonSamples = new Vector4[64];
        for (int i = 0; i < 64; ++i) {
            double r = Math.random();
            double s = 0.1 * r + 1.0 * (1.0 - r);
            this.poissonSamples[i] = new Vector4(Math.random() * 2.0 - 1.0, Math.random() * 2.0 - 1.0, Math.random(), 0.0).normalized().scale(s);
        }
    }

    public void render(Matrix44 ortho, Matrix44 projection, ColorBuffer colors, ColorBuffer normals, ColorBuffer positions, RenderTarget finalTarget) {
        this.intermediate.bindTarget();
        this.gl3.glDisable(2929);
        this.gl3.glActiveTexture(33984);
        normals.bindTexture((GL)this.gl3);
        this.gl3.glActiveTexture(33985);
        this.noiseImage.texture.bind((GL)this.gl3);
        this.gl3.glActiveTexture(33986);
        colors.bindTexture((GL)this.gl3);
        this.gl3.glActiveTexture(33987);
        positions.bindTexture((GL)this.gl3);
        this.gl3.glActiveTexture(33984);
        this.shader.begin();
        this.shader.setUniform("modelViewProjectionMatrix", ortho.transpose());
        this.shader.setUniform("projectionMatrix", projection.transpose());
        this.shader.setUniform1f("aspect", (float)this.height / (float)this.width);
        this.shader.setUniform1f("radius", 0.05f);
        this.shader.setUniform("poissonSamples", this.poissonSamples);
        this.shader.setUniform1i("normalMap", 0);
        this.shader.setUniform1i("noiseMap", 1);
        this.shader.setUniform1i("colorMap", 2);
        this.shader.setUniform1i("positionsMap", 3);
        VBODrawer.draw((GL3)this.gl3, (VAO)this.vao, (int)4, (int)6);
        this.shader.end();
        this.gl3.glBindTexture(3553, 0);
        this.intermediate.unbindTarget();
        this.blurShader.begin();
        double hwidth = this.width;
        double hheight = this.height;
        Vector2[] directions = new Vector2[]{new Vector2(1.0 / hwidth, 0.0), new Vector2(0.0, 1.0 / hheight)};
        int result = 0;
        for (int i = 0; i < 2; ++i) {
            int target = (1 + i) % 2;
            int source = i % 2;
            this.blur[target].bindTarget();
            this.gl3.glActiveTexture(33984);
            if (i != 0) {
                this.blurColors[source].bindTexture((GL)this.gl3);
            } else {
                this.intermediateColors.bindTexture((GL)this.gl3);
            }
            this.gl3.glActiveTexture(33985);
            positions.bindTexture((GL)this.gl3);
            this.gl3.glActiveTexture(33986);
            normals.bindTexture((GL)this.gl3);
            this.blurShader.setUniform("modelViewProjectionMatrix", ortho.transpose());
            this.blurShader.setUniform1i("colors", 0);
            this.blurShader.setUniform1i("positions", 1);
            this.blurShader.setUniform1i("normals", 2);
            double scale = 1.0;
            if (i == 0) {
                scale = 2.0;
            }
            this.blurShader.setUniform("blurDirection", directions[i % 2].scale(scale));
            this.blurShader.setUniform1i("window", 3);
            VBODrawer.draw((GL3)this.gl3, (VAO)this.vao, (int)4, (int)6);
            this.gl3.glActiveTexture(33985);
            this.gl3.glBindTexture(3553, 0);
            this.gl3.glActiveTexture(33984);
            this.gl3.glBindTexture(3553, 0);
            this.blur[target].unbindTarget();
            result = target;
        }
        this.blurShader.end();
        if (finalTarget != null) {
            finalTarget.bindTarget();
        }
        this.gl3.glActiveTexture(33984);
        colors.bindTexture((GL)this.gl3);
        this.gl3.glActiveTexture(33985);
        this.blurColors[result].bindTexture((GL)this.gl3);
        this.combineShader.begin();
        this.combineShader.setUniform("modelViewProjectionMatrix", ortho.transpose());
        this.combineShader.setUniform1i("colors", 0);
        this.combineShader.setUniform1i("occlusion", 1);
        VBODrawer.draw((GL3)this.gl3, (VAO)this.vao, (int)4, (int)6);
        this.combineShader.end();
        this.gl3.glActiveTexture(33985);
        this.gl3.glBindTexture(3553, 0);
        this.gl3.glActiveTexture(33984);
        this.gl3.glBindTexture(3553, 0);
        if (finalTarget != null) {
            finalTarget.unbindTarget();
        }
    }
}

