/*
 * Decompiled with CFR 0.152.
 */
package thimble.post;

import java.io.InputStream;
import java.nio.ByteBuffer;
import javax.media.opengl.GL;
import javax.media.opengl.GL3;
import net.lustlab.rndr.color.Color;
import net.lustlab.rndr.fbo.ColorBuffer;
import net.lustlab.rndr.image.Image;
import net.lustlab.rndr.math.Matrix44;
import net.lustlab.rndr.math.Transforms;
import net.lustlab.rndr.math.Vector2;
import net.lustlab.rndr.math.Vector3;
import net.lustlab.rndr.shaders.FragmentShader;
import net.lustlab.rndr.shaders.Shader;
import net.lustlab.rndr.shaders.VertexShader;
import net.lustlab.rndr.vbo.BufferWriter;
import net.lustlab.rndr.vbo.VAO;
import net.lustlab.rndr.vbo.VBO;
import net.lustlab.rndr.vbo.VBODrawer;
import net.lustlab.rndr.vbo.VBOLayout;

public class SSLR {
    GL3 gl3;
    Shader shader;
    VBO quad;
    VBOLayout layout;
    VAO quadVAO;
    Image noise;
    int width;
    int height;

    public SSLR(GL3 gl3, int width, int height) {
        this.width = width;
        this.height = height;
        this.gl3 = gl3;
        this.shader = Shader.createShader((GL)gl3, (VertexShader)VertexShader.load((GL)gl3, (InputStream)this.getClass().getResourceAsStream("/shaders/sslr/sslr.vert")), (FragmentShader)FragmentShader.load((GL)gl3, (InputStream)this.getClass().getResourceAsStream("/shaders/sslr/sslr.frag")));
        this.layout = new VBOLayout().textureCoordinate(2).position(3);
        ByteBuffer buffer = ByteBuffer.allocateDirect(this.layout.size() * 6);
        BufferWriter bw = new BufferWriter(buffer);
        double w = width;
        double h = height;
        Vector3 p00 = new Vector3(0.0, 0.0, 0.0);
        Vector3 p10 = new Vector3(w, 0.0, 0.0);
        Vector3 p11 = new Vector3(w, h, 0.0);
        Vector3 p01 = new Vector3(0.0, h, 0.0);
        Vector2 t00 = new Vector2(0.0, 1.0);
        Vector2 t10 = new Vector2(1.0, 1.0);
        Vector2 t11 = new Vector2(1.0, 0.0);
        Vector2 t01 = new Vector2(0.0, 0.0);
        bw.write(t11).write(p11).write(t10).write(p10).write(t00).write(p00);
        bw.write(t00).write(p00).write(t01).write(p01).write(t11).write(p11);
        buffer.rewind();
        this.quad = VBO.createStaticVBO((GL)gl3, (ByteBuffer)buffer, (long)(this.layout.size() * 6));
        this.noise = Image.drawable((GL)gl3, (int)width, (int)height);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                this.noise.write(x, y, new Color(Math.random(), Math.random(), Math.random(), Math.random()));
            }
        }
        this.noise.upload();
        this.quadVAO = VAO.createVAO((GL3)gl3, (VBO)this.quad, (VBOLayout)this.layout, (Shader)this.shader);
    }

    public void render(Matrix44 projection, ColorBuffer colors, ColorBuffer normals, ColorBuffer positions) {
        this.gl3.glDisable(2929);
        this.shader.begin();
        this.gl3.glActiveTexture(33984);
        colors.bindTexture((GL)this.gl3);
        this.gl3.glActiveTexture(33985);
        normals.bindTexture((GL)this.gl3);
        this.gl3.glActiveTexture(33986);
        positions.bindTexture((GL)this.gl3);
        this.gl3.glTexParameteri(3553, 10240, 9728);
        this.gl3.glTexParameteri(3553, 10241, 9728);
        this.gl3.glActiveTexture(33987);
        this.noise.texture.bind((GL)this.gl3);
        this.gl3.glActiveTexture(33984);
        this.shader.setUniform("quadProjectionMatrix", Transforms.ortho((double)0.0, (double)this.width, (double)this.height, (double)0.0, (double)-1.0, (double)1.0).transpose());
        this.shader.setUniform("projectionMatrix", projection.transpose());
        this.shader.setUniform1i("colors", 0);
        this.shader.setUniform1i("normals", 1);
        this.shader.setUniform1i("positions", 2);
        this.shader.setUniform1i("noise", 3);
        VBODrawer.draw((GL3)this.gl3, (VAO)this.quadVAO, (int)4, (int)6);
        this.shader.end();
        this.gl3.glActiveTexture(33987);
        this.gl3.glBindTexture(3553, 0);
        this.gl3.glActiveTexture(33986);
        this.gl3.glBindTexture(3553, 0);
        this.gl3.glActiveTexture(33985);
        this.gl3.glBindTexture(3553, 0);
        this.gl3.glActiveTexture(33984);
        this.gl3.glBindTexture(3553, 0);
    }
}

