/*
 * Decompiled with CFR 0.152.
 */
package thimble.sketches;

import framer.Animatable;
import framer.AnimationCompletedCallback;
import framer.Easing;
import javax.media.opengl.GL;
import net.lustlab.rndr.color.Color;
import net.lustlab.rndr.fbo.ColorBuffer;
import net.lustlab.rndr.fbo.DepthBuffer;
import net.lustlab.rndr.fbo.RenderTarget;
import net.lustlab.rndr.math.Matrix44;
import net.lustlab.rndr.math.Transforms;
import net.lustlab.rndr.sketch.SketchGL3;
import thimble.effects.Grids;
import thimble.post.HandyZoom;

public class GridsSketch
extends SketchGL3 {
    Grids grids;
    HandyZoom handyZoom;
    private ColorBuffer colors;
    private ColorBuffer normals;
    private ColorBuffer positions;
    private DepthBuffer depth;
    private RenderTarget renderTarget;

    GridsSketch() {
        this.configuration.width = 1280;
        this.configuration.height = 720;
    }

    public void setup() {
        this.grids = new Grids(this.gl3, this.width, this.height);
        this.handyZoom = new HandyZoom(this.gl3, this.width, this.height);
        this.colors = ColorBuffer.create((GL)this.gl3, (int)this.width, (int)this.height, (int)34836);
        this.normals = ColorBuffer.create((GL)this.gl3, (int)this.width, (int)this.height, (int)34836);
        this.positions = ColorBuffer.create((GL)this.gl3, (int)this.width, (int)this.height, (int)34836);
        this.depth = DepthBuffer.create((GL)this.gl3, (int)this.width, (int)this.height);
        this.renderTarget = RenderTarget.create((GL)this.gl3, (int)this.width, (int)this.height).attach(this.colors).attach(this.normals).attach(this.positions).attach(this.depth).unbindTarget();
        this.handyZoom.animate("x", 0.0, 0L).complete(new AnimationCompletedCallback(){

            public void animationCompleted(Animatable animatable) {
                int duration = (int)(Math.random() * 5000.0 + 500.0);
                animatable.animate("x", GridsSketch.this.grids.hotX, (long)duration, Easing.CubicInOut).animate("y", GridsSketch.this.grids.hotY, (long)duration, Easing.CubicInOut).add("tilex", 0.2 * (Math.random() - 0.5), (long)(duration / 4), Easing.CubicInOut).add("tiley", 0.2 * (Math.random() - 0.5), (long)(duration / 4), Easing.CubicInOut).add("offsetx", 0.2 * (Math.random() - 0.5), (long)duration, Easing.CubicInOut).add("offsety", 0.2 * (Math.random() - 0.5), (long)duration, Easing.CubicInOut).add("rotation", (Math.random() - 0.5) * 0.25, (long)duration, Easing.CubicInOut).animate("zoom", 0.25 * Math.random() + 0.125, (long)duration, Easing.CubicInOut).complete().delay(1000L).add("x", 0.0, 0L).complete((AnimationCompletedCallback)this);
            }
        });
    }

    public void draw() {
        this.background(Color.BLACK);
        Matrix44 ortho = Transforms.ortho((double)0.0, (double)this.width, (double)this.height, (double)0.0, (double)-1.0, (double)1.0);
        this.renderTarget.bindTarget();
        this.background(Color.WHITE);
        this.renderTarget.unbindTarget();
        this.handyZoom.draw(ortho, this.colors, this.seconds());
    }

    public static void main(String[] args) {
        SketchGL3.run((SketchGL3)new GridsSketch());
    }
}

