#version 330

uniform mat4 modelViewProjectionMatrix;
uniform mat4 normalMatrix;
uniform mat4 modelViewMatrix;

in vec3 position;
in vec3 normal;

out vec3 v_normal;
out vec3 v_position;

uniform float time;


mat4 rotationMatrix(vec3 axis, float angle)
{
    axis = normalize(axis);
    float s = sin(angle);
    float c = cos(angle);
    float oc = 1.0 - c;

    return mat4(oc * axis.x * axis.x + c,           oc * axis.x * axis.y - axis.z * s,  oc * axis.z * axis.x + axis.y * s,  0.0,
                oc * axis.x * axis.y + axis.z * s,  oc * axis.y * axis.y + c,           oc * axis.y * axis.z - axis.x * s,  0.0,
                oc * axis.z * axis.x - axis.y * s,  oc * axis.y * axis.z + axis.x * s,  oc * axis.z * axis.z + c,           0.0,
                0.0,                                0.0,                                0.0,                                1.0);
}

void main(void) {

    vec3 transformed = position;
    transformed.x*=(0.6+0.4*pow(0.5+0.5*cos(gl_InstanceID*0.03+time), 100));
transformed.y*=(0.6+0.4*pow(0.5+0.5*cos(gl_InstanceID*0.03+time), 100));
transformed.z*=(0.6+0.4*pow(0.5+0.5*cos(gl_InstanceID*0.03+time), 100));


    mat4 transformMatrix = rotationMatrix(normalize(vec3(cos(time*0.5436),cos(time+gl_InstanceID*0.03),cos(time*0.4325))), gl_InstanceID * 0.2);
    transformed.y += (gl_InstanceID-2500) * 0.0003;


    transformed = (transformMatrix * 1.5 * vec4(transformed,1)).xyz;


    gl_Position = modelViewProjectionMatrix * vec4(transformed,1.0);
    v_position = (modelViewMatrix * vec4(transformed, 1.0)).xyz;
    v_normal = normalize(( normalMatrix * transformMatrix * vec4(normal, 1.0)).xyz);

}