
#version 330

in vec3 v_normal;

in vec4 v_eyePos;
in vec4 v_worldPos;

in vec3 v_worldNormal;

in vec3 v_position;

in vec2 v_texCoord0;

layout(location = 0) out vec4 o_color;
layout(location = 1) out vec4 o_normal;
layout(location = 2) out vec4 o_position;

uniform mat4 normalMatrix;

in mat4 modelViewInverse;

void main() {


    //vec3 eyevec =  normalize(v_worldPos.xyz - v_eyePos.xyz);

    //vec3 reflection = normalize(reflect(eyevec, normalize(v_worldNormal)));

    vec3 reflection = (modelViewInverse * vec4(reflect(v_position, v_normal), 1)).xyz;


    float ring = length(reflection.xz)*1;
    float ceiling = clamp(-reflection.y - ring,0,1);


    vec2 h = abs(reflection.xz)*4;


    float h2 = max(0,min(1-h.x, 1-h.y));
    ring = smoothstep(0.25,0.30,h2);

    vec2 ddEdge = fwidth(v_texCoord0);
    vec2 dist = abs(v_texCoord0 - vec2(0.5));

    float constWidth = min(ddEdge.x, ddEdge.y);

    float d = min(dist.x, dist.y);

    float f = smoothstep(0, constWidth*2, d);

    f *= (1.0+(v_position.z/4.0));

    o_color = vec4(f*0.8);
    //o_color = ceiling * vec4(1,1,1,1);
//    o_color.rgb = (reflection.xyz / 2 + 0.5);
    //o_color.rgb = reflection;
    //o_color += vec4(ring,0,0,1);
    o_normal = vec4(normalize(v_normal), v_position.z);
    o_position = vec4(v_position, 1);

}