#version 330

uniform mat4 modelViewProjectionMatrix;
uniform mat4 normalMatrix;
uniform mat4 modelViewMatrix;

in vec3 position;
in vec3 normal;
in vec2 texCoord0;

out vec3 v_normal;
out vec3 v_position;
out vec2 v_texCoord0;

out vec4 v_eyePos;
out vec4 v_worldPos;
out vec3 v_worldNormal;

out mat4 modelViewInverse;
uniform float time;


uniform samplerBuffer positions;


void main(void) {


    mat4 transform = mat4(vec4(1,0,0,0),vec4(0,1,0,0),vec4(0,0,1,0),vec4(texelFetch(positions, gl_InstanceID).xyz,1));

    gl_Position = modelViewProjectionMatrix * transform * vec4(position,1.0);
    v_position = (modelViewMatrix * transform * vec4(position, 1.0)).xyz;
    v_normal = normalize(( normalMatrix * vec4(normal, 1.0)).xyz);
    v_texCoord0 = texCoord0;

    v_worldNormal = normal;
    v_worldPos = (transform * vec4(position, 1));


    modelViewInverse = inverse(modelViewMatrix);
//    v_eyePos = inverse(modelViewMatrix) * vec4(0,0,0,1);

    //v_eyePos = vec4(modelViewMatrix[3][0], modelViewMatrix[3][1],modelViewMatrix[3][2],1);


}