#version 150

in vec2 position;
in vec2 texCoord0;
uniform mat4 modelViewProjectionMatrix;
uniform samplerBuffer positions;

out vec2 v_texCoord0;

void main() {
    vec4 data = texelFetch(positions, gl_InstanceID);

    float rotation = data.z;
    vec2 origin =  data.xy;
    float scale = data.w;


    mat2 rotationMatrix = mat2(
        vec2(cos(rotation),sin(rotation)),
        vec2(-sin(rotation),cos(rotation))
    );

    vec2 transformed = origin + rotationMatrix*(position.xy * scale);

    // -- output --
    v_texCoord0 = texCoord0;
    gl_Position = modelViewProjectionMatrix * vec4(transformed, 0, 1);
}