#version 150

// -- uniforms: transforms
uniform mat4 modelViewProjectionMatrix;
uniform samplerBuffer positions;

uniform float slidingFactor;

// --- inputs ---
in vec2 position;
in vec2 texCoord0;

// -- outputs --
out vec2 v_position;
out vec2 v_texCoord0;

out float v_fill;


const vec2 fmasks[4] = vec2[](vec2(0,1), vec2(0,1), vec2(1,0), vec2(1,0));
const vec2 fdirs[4] = vec2[](vec2(0,1), vec2(0,0), vec2(1,0), vec2(0,0));

void main() {

    float scale = 16;

    vec4 instanceData = texelFetch(positions, gl_InstanceID);
    v_fill = instanceData.z;
    int direction = int(instanceData.w) % 4;
    int hatching = int(instanceData.w);

    vec2 fmask = fmasks[direction] * slidingFactor;
    vec2 fdir = fdirs[direction];

    vec2 vdir = (vec2(0.5) + position) - fdir;
    vdir.x *= fmask.x;
    vdir.y *= fmask.y;


    vec2 transformed = (position*scale - vdir*scale * (1.0-v_fill)) + vec2(0.5) * scale + (instanceData.xy * scale);



    gl_Position = modelViewProjectionMatrix * vec4(transformed, 0, 1);
    v_position = gl_Position.xy;
    v_texCoord0 = (position+vec2(0.5)) - vdir* (1.0-v_fill);
    v_texCoord0.x /= 16.0;
    v_texCoord0.x += (1.0/16.0) * hatching;
}