#version 150

uniform sampler2D image;
in vec2 v_texCoord0;
in vec2 v_normal;
in vec3 v_objectPosition;

uniform float time;

uniform float intensity;
out vec4 o_color;

void main() {
    vec3 rgb = texture(image, v_texCoord0).rgb;

    float c = ((rgb.r + rgb.g + rgb.b) / 3.0) * intensity;
    c = pow(c, 1.4) * (0.5+cos(gl_FragCoord.x + gl_FragCoord.y)*0.5);

    vec4 m = vec4(209/255.0, 221.0/255, 221.0/255.0,1.0);
    o_color = vec4(c,c,c,1) * m;
}