#version 150

/*
    SSAO blur shader
*/

uniform sampler2D colors;
uniform sampler2D positions;
uniform sampler2D normals;
uniform vec2 blurDirection;
uniform int window;

in vec2 v_texCoord0;
out vec4 o_color;

void main() {


    float depth = texture(positions, v_texCoord0).z;
    vec3 normal = normalize(texture(normals, v_texCoord0).xyz);

    vec4 sum = vec4(0);
    float weight = 0;
    for (int i = -window; i <= window; ++i) {

        vec2 sampleCoord =  v_texCoord0 + i * blurDirection;
        float sampleDepth = texture(positions, sampleCoord).z;
        vec3 sampleNormal = normalize(texture(normals, sampleCoord).xyz);
        if (abs(depth - sampleDepth) < 0.01 && dot(sampleNormal, normal) > 0.9 ) {
            sum += texture(colors, sampleCoord);
            weight+=1;
        }

    }
    sum /= weight;

    if (weight > 0) {
    o_color = sum;
    }
    else {
    o_color = vec4(1);
    }



}