#version 150

// -- GBuffers --
uniform sampler2D normalMap;
uniform sampler2D noiseMap;
uniform sampler2D colorMap;
uniform sampler2D positionsMap;

// -- random samples --
uniform vec4 poissonSamples[64];

// -- transforms
uniform mat4 projectionMatrix;

uniform float radius; // the radius in which samples should be taken around the origin

// -- inputs --
in vec3 v_eyeDir;
in vec2 v_texCoord0;


// -- outputs --
out vec4 o_color;


void main(void) {

    vec3 origin = texture(positionsMap, v_texCoord0).xyz;
    vec3 normal = normalize(texture(normalMap, v_texCoord0).xyz);

    // rotate around normal
    vec3 randomVector = normalize(texture(noiseMap, v_texCoord0).xyz * 2.0 -1.0);
    vec3 tangent = normalize(randomVector - normal * dot(randomVector, normal));
    vec3 bitangent = cross(normal, tangent);
    mat3 tbn = mat3(tangent, bitangent, normal);

    float occlusion = 0.0;

    for (int i = 0; i < 16; ++i) {

        vec3 sampleV = origin + (radius * tbn * poissonSamples[i].xyz);
        vec4 sampleS = projectionMatrix * (vec4(sampleV,1));
        sampleS.xy = (sampleS.xy / sampleS.w) * 0.5 + 0.5;

        float sz = texture(positionsMap, sampleS.xy).z;

        //float rangeCheck = (origin.z - sz) < radius? 1.0: 0.0;
        //float rangeCheck = 1.0;
        float o = ((sz - sampleV.z))*1.0;

        o = min(1, sqrt(o));

        occlusion += o; //(sz > sampleV.z ? 1.0 : 0.0) * rangeCheck;
    }

occlusion = occlusion / 16.0;
    //occlusion = 1.0 - occlusion / 16.0;

    o_color = vec4(occlusion);//vec4(occlusion) * texture(colorMap, v_texCoord0);
}
