#version 150

/*
    SSLR fragment shader

*/


// --- varyings ---
in vec2 v_texCoord0;

// --- G buffer ---
uniform sampler2D colors;
uniform sampler2D normals;
uniform sampler2D positions;

uniform sampler2D noise;

// --- transforms ---
uniform mat4 projectionMatrix;

// --- output ---
out vec4 o_color;


vec2 screen(vec3 world) {
    vec4 projected = (projectionMatrix * vec4(world,1));
    return vec2(projected.x/projected.w, projected.y/projected.w) / 2 + 0.5;
}


void main() {

    vec4 color = texture(colors, v_texCoord0);

     vec3 viewNormal = texture(normals, v_texCoord0).xyz + (texture(noise, v_texCoord0*1).xyz - 0.5) * 0.00;
     vec3 viewPos = texture(positions, v_texCoord0).xyz;
     vec3 reflected = normalize(reflect(normalize(viewPos), normalize(viewNormal)));

     vec3 rayPos = viewPos;
     vec3 rayDir = reflected;// * (0.3 + 0.001*texture(noise, v_texCoord0).x); // * max( 0.1, -viewPos.z);

    if (length(viewNormal) == 0) {
        o_color = color;
        return;
    }

     float found = 0;
     for (int i = 0; i < 1280; ++i) {
           rayPos+=rayDir;

           float depth = texture(positions, screen(rayPos)).z;

           float dDepth = rayPos.z - depth;

           if (dDepth < 0 && depth != 0) {
                found = 1;

                    for(int bi = 0; bi < 100; bi++)     {
                        depth = texture(positions, screen(rayPos)).z;
                        if (depth == 0) {
                        depth = -100000;
                        }
                        dDepth = rayPos.z - depth;

                        if(dDepth > 0.0) {
                            rayPos += rayDir;
                        }
                        else {
                            rayPos -= rayDir;
                        }

                        rayDir *= 0.5;// + 0.3*(texture(noise,v_texCoord0).x);

                    }

                }

                break;
           }


    float distance = length(rayPos - viewPos);


    vec2 coords = screen(rayPos);
      vec2 dCoords = abs(vec2(0.5, 0.5) - coords);

    color *= 0.5;


    float r = max(0.0, dot(reflected, normalize(viewPos)));

    float searchFactor = clamp((1 - length(viewPos - rayPos)* 2) , 0.0, 1.0) * 1;
    r = 1;
    searchFactor = 1;

    float screenEdgefactor = clamp(1.0 - (dCoords.x + dCoords.y), 0.0, 1.0);
    screenEdgefactor = 1;
    color += found * vec4(texture(colors, screen(rayPos))) * screenEdgefactor * searchFactor
    //* clamp(-reflected.z, 0.0, 1.0)
    * r;
    o_color = color;

}