#version 150

// -- transforms --
uniform mat4 modelViewProjectionMatrix;
uniform mat4 normalMatrix;

uniform vec3 offset;
uniform vec3 dimensions;

// -- vertex --
in vec3 position;
in vec3 normal;
in vec2 texCoord0;

// -- output --
out vec2 v_texCoord0;
out vec3 v_normal;




void main() {

    vec3 transformed = (position * dimensions) + offset;

    gl_Position = (modelViewProjectionMatrix * vec4(transformed, 1));
    v_normal = (normalMatrix * vec4(normal, 0)).xyz;
    v_texCoord0 = texCoord0;

}