/*
	RNDR / post_grayscale.frag
	Edwin Jakobs (edwin@lustlab.net)
*/

uniform sampler2D texture;
uniform sampler2D texture1;

void main() {
    vec4 col = texture2D(texture, gl_TexCoord[0].xy);
    vec4 col1 = texture2D(texture1, gl_TexCoord[0].xy);
    vec4 top = vec4(0.6,0.6,0.7,1) * gl_TexCoord[0].y + vec4(0.5,0,0,1) * (1.0-gl_TexCoord[0].y);

    vec4 bottom = col+col1;

    vec4 blend;
    blend.r = bottom.r < 0.5? 2.0 * top.r * bottom.r : 1.0 - 2.0 * (1.0-top.r) * (1.0-bottom.r);
    blend.g = bottom.g < 0.5? 2.0 * top.g * bottom.g : 1.0 - 2.0 * (1.0-top.g) * (1.0-bottom.g);
    blend.b = bottom.b < 0.5? 2.0 * top.b * bottom.b : 1.0 - 2.0 * (1.0-top.b) * (1.0-bottom.b);
    blend.a = 1.0;


    gl_FragColor = blend;
}