/*
 * Decompiled with CFR 0.152.
 */
package io.lacuna.artifex.utils;

import io.lacuna.bifurcan.ISet;
import io.lacuna.bifurcan.LinearSet;
import java.util.Comparator;
import java.util.PriorityQueue;

public class SweepQueue<T> {
    public static final int OPEN = 0;
    public static final int CLOSED = 1;
    private final PriorityQueue<Event<T>> queue = new PriorityQueue<Event>(Event.COMPARATOR);
    private final ISet<T> set = new LinearSet<T>();

    public void add(T value2, double a2, double b) {
        this.queue.add(new Event<T>(Math.min(a2, b) - 1.0E-14, value2, 0));
        this.queue.add(new Event<T>(Math.max(a2, b) + 1.0E-14, value2, 1));
    }

    public double peek() {
        return this.queue.isEmpty() ? Double.MAX_VALUE : this.queue.peek().key;
    }

    private static <T> int compare(SweepQueue<T> a2, SweepQueue<T> b) {
        return Event.COMPARATOR.compare(a2.queue.peek(), b.queue.peek());
    }

    public static <T> int next(SweepQueue<T> ... queues) {
        while (true) {
            int minIdx = 0;
            for (int i = 1; i < queues.length; ++i) {
                if (!queues[minIdx].queue.isEmpty() && (queues[i].queue.isEmpty() || SweepQueue.compare(queues[i], queues[minIdx]) >= 0)) continue;
                minIdx = i;
            }
            SweepQueue<T> q = queues[minIdx];
            if (q.queue.isEmpty() || q.queue.peek().type == 0) {
                return minIdx;
            }
            q.next();
        }
    }

    public Event<T> next() {
        Event<T> e = this.queue.poll();
        if (e == null) {
            return null;
        }
        if (e.type == 1) {
            this.set.remove(e.value);
        } else {
            this.set.add(e.value);
        }
        return e;
    }

    public T take() {
        while (!this.queue.isEmpty()) {
            Event<T> e = this.next();
            if (e.type != 0) continue;
            return e.value;
        }
        return null;
    }

    public ISet<T> active() {
        return this.set;
    }

    public static class Event<T> {
        static final Comparator<Event> COMPARATOR = (a2, b) -> {
            double diff = a2.key - b.key;
            if (diff == 0.0) {
                return a2.type - b.type;
            }
            return (int)Math.copySign(1.0, diff);
        };
        public final double key;
        public final T value;
        public final int type;

        Event(double key, T value2, int type2) {
            this.key = key;
            this.value = value2;
            this.type = type2;
        }
    }
}

