; =========================================================================
; singen - a 16 byte sine generator for M68k by superogue / marquee design|
; =========================================================================
	OPT O+,D-,X-


	incdir  "include"
	include "graphics/graphics_lib.i"
	include "intuition/screens.i"
	include "hardware/custom.i"
	include "hardware/dmabits.i"


SIZE	equ 256	

Main:
	; optional - backup bss address (initialised in a4 on Atari ST) for drawing	
	lea  sintab(pc),a4	; 

	; sine generator (16 bytes)
	moveq #127,d2		;2b 
	moveq #0,d3			;2b (Amiga only)
singen:
	subq.l	#2,d2		;2b
	move.l	d3,d0		;2b
	move.w	d0,(a4)+	;2b
	sub.w	d0,(SIZE-2,a4)	;4b
	add.l	d2,d3		;2
	bne.b	singen		;2b


	; Amiga init 
	move.l  $170(a2),a6     ; intuitionbase from globvec
	move.l  ib_ActiveScreen(a6),a5
	move.l  $4.w,a6         ; execbase
	move.l  156(a6),a6      ; graphics.library
	lea     sc_ViewPort(a5),a0

    lea     sc_RastPort(a5),a1
    jsr     _LVOClearScreen(a6)


	; draw sine
	lea  sintab(pc),a4
	move.w #255,d5
drawloop:	
	; read sine value and scale back for plotting
	move.w (a4)+,d1	
	asr.w #6,d1	
	add.w #100,d1		

	; plot pixel
	move d5,d0
	add d0,d0
	jsr     _LVOWritePixel(a6)

    dbra d5,drawloop
	
	; wait loop
	bra.s *

sintab:
