; Blobs.asm
; Classic morphing blob effect.
; Sadly, interlaced for speed reasons :(
; The extra rings around the blobs are overflow errors, but look rather nice.
; This effect looks better at 15MHz; but I'm the sad owner of a TI-83 Plus
; (non SE) so I like to keep it at a sedate 6MHz. The bottleneck seems to be
; the multiplication operation performed on every pixel.
; By default, the screen is cropped to 64x64 of blobbiness. Comment out
; crop_display for full 96x64 goodness, at a speed hit.

.module Blobs
.using noname
.varloc variable_free, free_space
_textheight = 12

.var 1, _0_x_a
.var 1, _0_y_a
.var 1, _1_x_a
.var 1, _1_y_a
.var 1, _scroll_angle
.var _textheight*13, _text_buffer
.var 2, _text_pointer
.var 1, _text_smooth

.define crop_display
Blobs
	ld hl,_text
	ld (_text_pointer),hl
	ld a,2
	ld (_text_smooth),a
	ld hl,_text_buffer
	ld bc,13*_textheight
	xor a
	bcall(_MemSet)

_loop

	; Animate...
	.define advance_blob_angle(angle, dphase, offset, result) 
	.defcont ld a,(angle) \
	.defcont add a,dphase \
	.defcont ld (angle),a \
	.defcont ld d,0 \
	.defcont ld e,a \
	.defcont ld hl,_sin_table \
	.defcont add hl,de \
	.defcont ld a,(hl) \
	.defcont add a,offset \
	.defcont ld (result+1),a
	
	advance_blob_angle(_0_x_a, +3, 48, _0_x_p)
	advance_blob_angle(_0_y_a, +7, 32, _0_y_p)
	advance_blob_angle(_1_x_a, -5, 48, _1_x_p)
	advance_blob_angle(_1_y_a, -2, 32, _1_y_p)
	
	ld a,(_scroll_angle)
	add a,6
	ld (_scroll_angle),a
	ld l,a
	ld h,0
	ld de,_sin_table
	add hl,de
	ld a,(hl)
	sra a
	add a,32+$80-5
	ld (_scroller_top+1),a
	add a,_textheight
	ld (_scroller_bottom+1),a



	; Calculate X tables

_0_x_p
	ld a,0 ; BLOB 0 X
	neg
	.ifdef crop_display
	add a,16
	.endif
	ld c,a

_1_x_p
	ld a,0 ; BLOB 1 X
	neg
	.ifdef crop_display
	add a,16
	.endif	
	ld e,a
	
	.ifdef crop_display
	ld b,64
	.else
	ld b,96	
	.endif
	
	ld d,_square_table >> 8
	ld hl,_x_table
-

	; Look up x0²
	ld ixl,e
	ld e,c
	ld a,(de)
	ld (hl),a
	inc hl
	
	
	
	; Look up x1²
	ld e,ixl
	ld a,(de)
	ld (hl),a
	inc hl
	
	inc c
	inc e	

	djnz {-}
	
	; Calculate Y tables

_0_y_p
	ld a,0 ; BLOB 0 Y
	neg
	ld c,a

_1_y_p	
	ld a,0 ; BLOB 1 Y
	neg
	ld e,a


	
	ld b,32
	ld d,_square_table >> 8
	ld hl,_y_table
-

	; Look up y0²
	ld ixl,e
	ld e,c
	ld a,(de)
	ld (hl),a
	inc hl
	
	; Look up y1²
	ld e,ixl
	ld a,(de)
	ld (hl),a
	inc hl
	
	inc c
	inc c
	inc e
	inc e
	

	djnz {-}
	
	; Now we have the two tables calculated, we need to render!
	

	; Set y-increment mode (increments X)
	ld a,$07
	call safe_lcd_pause
	out ($10),a
	
_initial_row
	ld a,$80	; Prime it with row 0
	ld (_set_y_offset+1),a

	ld hl,_y_table
	push hl

_next_row:
	ld a,$20	; Jump to column 0
	call safe_lcd_pause	
	out ($10),a

	pop hl
	
	ld a,(hl)
	inc hl
	ld (_y_0_sq+1),a
	
	ld a,(hl)
	inc hl
	ld (_y_1_sq+1),a
	
	push hl


	ld hl,_x_table	; hl->x²

_set_y_offset
	ld a,$80	; Go to next row
	out ($10),a
	
_scroller_top
	cp $80
	jp c,_copy_as_usual
_scroller_bottom
	cp $84
	jp c,_skip_drawing


_copy_as_usual

	.ifdef crop_display
_border_1
	ld a,%11001100
	call safe_lcd_pause
	out ($11),a
	call safe_lcd_pause
	out ($11),a

	ld ixl,8
	.else
	ld ixl,12
	.endif
_row_loop

	ld c,%10000000	; Pixel plot mask
	ld b,0	; Byte we're building up	
_build_up_data_byte

	; Do our operation in here...
	
	
	ld a,(hl) ; x0²
	inc l
	
_y_0_sq
	add a,$00 ; +y0²
	ld e,a
	

	ld a,(hl) ; x1²
	inc l
_y_1_sq
	add a,$00 ; +y1²
	
	
	; Multiply

	push hl
	
	ld d,0
	ld hl,0
.for i, 0, 7
	rrca
	jp nc,{+}
	add hl,de
+
	sla e
	rl d
.loop


	ld a,h
	or a
	jp nz,_pixel_off
	ld a,b
	or c
	ld b,a
_pixel_off
	pop hl
	
	srl c
	jp nc,_build_up_data_byte
	
	; Write to LCD:
	ld a,b
	cpl
	out ($11),a
	
	dec ixl
	jp nz,_row_loop
	
	.ifdef crop_display
_border_0
	ld a,%11001100
	call safe_lcd_pause
	out ($11),a
	call safe_lcd_pause
	out ($11),a
	ld a,(_border_0+1)
	cpl
	ld (_border_0+1),a
	ld (_border_1+1),a
	.endif	
	
_skip_drawing
	; Move down a row
	ld a,(_set_y_offset+1)
	inc a
	inc a
	cp $80+64\ jp z,_finished_frame
	cp $80+65\ jp z,_finished_frame
	ld (_set_y_offset+1),a
	
	jp _next_row
_finished_frame
	ld a,(_initial_row+1)
	xor 1
	ld (_initial_row+1),a
	
	; Copy in the text scroller

	ld a,(_scroller_top+1)
	ld ixl,a
	ld hl,_text_buffer

_scroller_loop
	ld a,$20
	call safe_lcd_pause
	out ($10),a
	
	ld a,ixl
	call safe_lcd_pause
	out ($10),a
	
	ld b,12
-
	ld a,(hl)
	inc hl
	call safe_lcd_pause
	out ($11),a
	djnz {-}
	inc hl
	inc ixl
	ld a,(_scroller_bottom+1)
	cp ixl
	jp nz,_scroller_loop
	
	
	;ld a,(_border_0+1)
	;cpl
	;ld (_border_0+1),a
	;ld (_border_1+1),a
	
	
	pop hl
	
	; Draw the text scroller

	.for j, 1, 2
	ld hl,_text_buffer+12+13*(_textheight-1)
	ld b,11
-	.for i, 1, 13
	rl (hl)\ dec hl
	.loop
	djnz {-}
	.loop

		
	ld a,(_text_smooth)
	sub 2
	and 7
	ld (_text_smooth),a	
	jp nz,_no_need_scroll
	
	
	ld hl,(_text_pointer)
	ld a,(hl)
	cp $FF
	jp nz,_not_loop_point
	ld hl,_text
	ld a,(hl)
_not_loop_point
	inc hl
	ld (_text_pointer),hl
	ld l,a
	ld h,0
	add hl,hl
	add hl,hl
	add hl,hl
	
	
	ld de,font
	add hl,de
	ld b,h
	ld c,l
	
	xor a
	ld (_text_buffer+12),a
	ld (_text_buffer+12+13),a
	
	.for i,10,_textheight-1
	ld (_text_buffer+12+13*i),a
	.loop

	ld hl,_text_buffer+13*2+12
	ld de,13
	.for x,1,8
	ld a,(bc)
	ld (hl),a
	inc bc
	add hl,de
	.loop
	
_no_need_scroll
	call scene_countdown
	jp _loop
	
.endmodule