; Cylinder.asm
; Wrap a line of scrolling text around a 'cylinder'
; and have multiple copies in the inner ring. :)
; Just a trick of scaling the backbuffer down
; to 50% and dithering rather than clearing it!

.module Cylinder
.using noname
.varloc variable_free, free_space
.var 1,_fine_scroll
.var 1,_rotation
.var 2,_text_pointer
.var 16*8,_text_scroll



Cylinder

	bcall(_GrBufClr)

	ld hl,_text
	ld (_text_pointer),hl
	ld (_text_reset+1),hl
	
	ld hl,saveSScreen
	ld bc,768
	xor a
	bcall(_MemSet)
	
	ld hl,_text_scroll
	ld bc,16*8
	xor a
	bcall(_MemSet)
	
	call _scroll_in_character
	call _scroll_in_character
	
	xor a
	ld (_rotation),a
	ld (_fine_scroll),a

_loop


	ld a,(_fine_scroll)
	inc a
	and 7
	ld (_fine_scroll),a

	jp nz,{+}
		
	; Scroll in a new piece of text
	call _scroll_in_character
+


	ld hl,plotSScreen
	ld de,saveSScreen
	ld ixl,64	
--
	ld b,12	
-	ld c,(hl)
	xor a
	.for i,1,4
	sla c
	sla c
	rl a
	.loop
	inc hl
	ld c,(hl)
	or a
	.for i,1,4
	sla c
	sla c
	rl a
	.loop
	inc hl
	ld (de),a
	inc de
	djnz {-}
	push de
	ld de,12
	add hl,de
	pop de
	dec ixl
	jr nz,{--}
	

	bcall(_GrBufClr)

	ld hl,plotSScreen+16*12+3
	ld de,saveSScreen
	ld ixl,32
--	ld b,6
-	ld a,(de)
_dither
	and %10101010
	ld (hl),a
	inc hl
	inc de
	djnz {-}
	push de
	ld de,6
	add hl,de
	pop de
	ld a,(_dither+1)
	cpl
	ld (_dither+1),a
	dec ixl
	jr nz,{--}
	ld a,(_dither+1)
	cpl
	ld (_dither+1),a
	
	ld a,(_fine_scroll)
	srl a
	srl a
	srl a
	ld (_rotation_fine_scroll+1),a

	ld hl,_horizontal_stretch
	ld (_horizontal_scale_counter+1),hl
	
	ld hl,_vertical_stretch
	ld (_vertical_scale_counter+1),hl
	
	; Pre-read...
	ld hl,_text_scroll
	ld (_source_location+1),hl
	
	ld a,$80
	ld b,a ; Pixel READ column
	ld c,a ; Pixel WRITE column

	ld hl,plotSScreen+1
	ld (_buffer_location+1),hl

	ld a,(_fine_scroll)
	or a
	jr z,{+}
-	srl b
	dec a
	jr nz,{-}
+
	
	ld ixh,10 ; Total byte columns of dest

_stretch_next_column

	; Render a column
	ld ixl,8 ; Rows of source

_horizontal_scale_counter
	ld hl,0
	
	ld a,(hl) ; Rows of destination
	inc hl
	ld (_horizontal_scale_counter+1),hl
	ld (_height_scale_s1_a+1),a
	ld (_height_scale_s1_b+1),a
	
	; How many rows down do we need to go?
	srl a
	ld h,a
	ld a,32
	sub h
	ld l,a
	ld h,0
	add hl,hl
	add hl,hl
	ld d,h
	ld e,l
	add hl,hl
	add hl,de
	ld d,h
	ld e,l
	
_buffer_location
	ld hl,0

	add hl,de
	
	
_source_location
	ld de,0
	
	
_draw_next_pixel_in_column
	ld a,(de) ; de->to stretch
	and b
	jp z,_pixel_off ; It's off
	ld a,(hl)
	or c
	ld (hl),a
_pixel_off
	; Now we need to down to the next pixel...
	push de
	ld de,12
	add hl,de
	pop de
	
_height_scale_s1_a
	ld a,0
	sub 8
	jp p,_not_time_to_advance_yet
_height_scale_s1_b
	add a,0
	inc de ; Move to next row of source	
	; We need to advance to the next row of the source
	dec ixl ; How many rows of source do we need to copy?
	jp z,_finished_stretching_column
	
_not_time_to_advance_yet
	ld (_height_scale_s1_a+1),a
	jp _draw_next_pixel_in_column
	
_finished_stretching_column

	; We need to go to the next column.

_write_dir ; SMC
	srl c ; WRITE
	jp nc,{+}
	dec ixh
	jp z,_finished_entire_display
_write_preset ; SMC
	ld c,$80
	ld hl,(_buffer_location+1)
_write_advance
	inc hl
	ld (_buffer_location+1),hl

+
	; How many columns of source data do we need to skip?

	ld a,(_rotation)
	ld e,a

_vertical_scale_counter	
	ld hl,0
	ld a,(hl)
_rotation_fine_scroll
	add a,0
	inc hl
	ld (_vertical_scale_counter+1),hl

	ld (_rotation),a ; New rotation


	sub e

	srl a
			
	jp z,_stretch_next_column ; No need to advance to next col.

-	srl b
	jp nc,{+}
	ld b,$80
	; Move to next column of source data
	ld hl,(_source_location+1)
	ld de,8
	add hl,de
	ld (_source_location+1),hl
+	
	dec a
	jp nz,{-}


	jp _stretch_next_column
	


_finished_entire_display ; FINISHED!

	call ionFastCopy
	call scene_countdown
	jp _loop

_scroll_in_character
	
	; Shunt everything along
	
	ld hl,_text_scroll+8
	ld de,_text_scroll
	ld bc,8*15
	ldir
	

	ld hl,(_text_pointer)
	ld a,(hl)
	cp $FF

	jr nz,_no_reset_text
_text_reset
	ld hl,0
	ld a,(hl)		
_no_reset_text

	inc hl
	ld (_text_pointer),hl
	call get_char
	ld de,_text_scroll+(14*8)
	ld bc,8
	ldir
	
	ld a,KeyRow_Pad
	out (1),a
	in a,(1)
	and ~(dKUp&dkDown)
	ret nz
	
	ld hl,-8
	add hl,de
	ld b,8
	
-	ld a,(hl)
	cpl
	ld (hl),a
	inc hl
	djnz {-}
	
	ret

.endmodule