.module Title
.using noname
.varloc variable_free, free_space
.var 14*16,_shadow_buffer
.var 13*8,_main_buffer ; Assumed to be consecutive!
.var 1,_shadow_copy_char_timeout
.var 2,_greets_shadow_pointer
.var 2,_greets_main_pointer
.var 1,_scroll_delay
.var 1,_text_height
.var 1,_col_counter
.var 1,_row_counter
.var 2,_type_pointer

Title

	ld hl,_shadow_buffer
	ld bc,13*8+14*16
	xor a
	bcall(_MemSet)
	
	ld hl,saveSScreen
	ld bc,768
	xor a
	bcall(_MemSet)

	ld hl,_background_text
	ld (_type_pointer),hl
	ld (_type_reset+1),hl

	xor a
	ld (_row_counter),a
	ld (_col_counter),a

	ld hl,_greets
	ld (_greets_reset+1),hl
	ld (_greets_main_pointer),hl
	
	ld hl,_greets-3
	ld (_greets_shadow_pointer),hl

	
	ld a,1
	ld (_shadow_copy_char_timeout),a
	xor a
	ld (_text_height),a
	
_loop
 
	ld a,(_text_height)
	inc a
	ld (_text_height),a


	ld a,(_scroll_delay)
	inc a
	and 1
	ld (_scroll_delay),a
	jp nz,_no_time_for_scrolling


	; Scroll shadow buffer...
	ld hl,_shadow_buffer+14*16-1
	ld b,16
-
	scf
	ccf
	.for i,1,14
	rl (hl)
	dec hl
	.loop
	djnz {-}
	
	; Scroll main buffer...
	ld a,(_shadow_copy_char_timeout)
	
	bit 0,a
	jr z,_half_speed_main_buffer
	ld hl,_main_buffer+13*8-1
	ld b,8
-
	scf
	ccf
	.for i,1,13
	rl (hl)
	dec hl
	.loop
	djnz {-}

_half_speed_main_buffer
		
	

	ld a,(_shadow_copy_char_timeout)
	dec a
	and $F
	ld (_shadow_copy_char_timeout),a
		
	jr nz,_not_time_new_char
	
	; Copy in the new characters...

	; Shadow...
	ld hl,(_greets_shadow_pointer)
	ld a,(hl)
	call get_char
	push hl
	pop ix

	ld hl,_shadow_buffer+12
	ld b,8
-
	push bc
	.for i,1,2
	ld a,(ix)
	call put_double_byte
	ld de,12
	add hl,de
	.loop
	inc ix
	pop bc
	djnz {-}
	
	; Main text
	
	ld hl,(_greets_main_pointer)
	ld a,(hl)
	call get_char
	ld d,h
	ld e,l
	ld hl,_main_buffer+12
	ld a,8
	ld bc,13
	ld ixl,8
-	
	ld a,(de)
	ld (hl),a
	inc de
	add hl,bc
	dec ixl
	jr nz,{-}
	
	ld hl,(_greets_shadow_pointer)
	call _advance_text
	ld (_greets_shadow_pointer),hl
	
	ld hl,(_greets_main_pointer)
	call _advance_text
	ld (_greets_main_pointer),hl

_not_time_new_char


_no_time_for_scrolling
				
	ld hl,saveSScreen
	ld de,plotSScreen
	ld a,(_text_height)
	bit 1,a
	jp nz,{+}
	
	; Clear the TOP ROW
	ld hl,plotSScreen
	xor a
	ld b,12
-
	ld (hl),a
	inc hl
	djnz {-}
		
	ld hl,saveSScreen+12
	ld de,plotSScreen+12
	
+

	ld c,32
--
	ld b,12
-	ld a,(hl)
_background_dither
	and %10101010
	ld (de),a
	inc hl
	inc de
	djnz {-}

	ld a,$00
	ld b,12	
-	ld (de),a
	inc hl
	inc de
	djnz {-}
	
	dec c
	jr nz,{--}

	
	ld a,(_background_dither+1)
	cpl
	ld (_background_dither+1),a
		
	; Copy shadow buffer to screen buffer
	
	ld a,(_text_height)
	ld l,a
	ld h,0
	ld de,_height_table
	add hl,de
	ld a,(hl)
	ld ixh,a
	add a,32-8
	call a_times_12
	ld de,plotSScreen
	add hl,de
	ld de,_shadow_buffer
	ld ixl,16
	
-	

	ld b,12

--	ld a,(de)

_shadow_dither
	and %10101010
	or (hl)
	ld (hl),a
	inc hl
	inc de
	djnz {--}

	inc de
	inc de
	ld a,(_shadow_dither+1)
	cpl
	ld (_shadow_dither+1),a
	dec ixl
	jr nz,{-}
	
	; Copy main text buffer to screen buffer
	
	
	ld a,ixh
	sra a
	add a,32-4
	call a_times_12
	ld de,plotSScreen
	add hl,de
	ld de,_main_buffer
	ld c,8
--
	ld b,12
-	ld a,(de)
	or (hl)
	ld (hl),a
	inc hl
	inc de
	djnz {-}
	
	inc de
	dec c
	jr nz,{--}	
	
	ld a,(_shadow_dither+1)
	cpl
	ld (_shadow_dither+1),a
	
	; Copy to LCD	
	call ionFastCopy
	
	; Advance the background text...
	
	ld a,(_text_height)
	and 7
	jp nz,_no_add_char
	
	ld a,(_row_counter)
	and 7
	add a,a
	add a,a
	add a,a
	call a_times_12
	
	ld a,(_col_counter)
	cp 12
	jp z,_skip_this_char
	ld e,a
	ld d,0
	add hl,de
	ld de,saveSScreen
	add hl,de
	
	push hl

	ld hl,(_type_pointer)
	ld a,(hl)
	cp $FF
	jr nz,{+}
_type_reset
	ld hl,0
	ld a,(hl)	
+
	inc hl
	ld (_type_pointer),hl
	call get_char
	
	pop de
	
	ex de,hl
	
	ld ixl,8
	ld bc,12
-	ld a,(de)
	inc de
	ld (hl),a
	add hl,bc
	dec ixl
	jr nz,{-}
	
_skip_this_char
	; Advance the counters...
	
	ld a,(_col_counter)
	inc a
	ld (_col_counter),a
	cp 12
	jr nz,{+}
	xor a
	ld (_col_counter),a
	ld a,(_row_counter)
	inc a
	ld (_row_counter),a
+
	
	
_no_add_char

	ld a,(_row_counter)
	cp 8
	jp nz,_no_scroll_up

	ld hl,saveSScreen+12
	ld de,saveSScreen
	ld bc,768-12
	ldir
	ld hl,saveSScreen+12*63
	ld bc,12
	xor a
	bcall(_MemSet)
	
	ld a,(_text_height)
	inc a
	and 7
	jr nz,{+}
	ld a,7
	ld (_row_counter),a	
+

_no_scroll_up
	call scene_countdown
	jp _loop

_advance_text
	; hl = pointer (will be adjusted)
	inc hl
	ld a,(hl)
	cp $FF
	ret nz
_greets_reset
	ld hl,0
	ret

_height_table
.dbsin 256, (64-16)/2, 0, 255, 1, 0

.endmodule
