  
/*

  framebuffer/color macros/gui colors

  27/04/2002

*/


#ifndef FRAMEBUFFER_H
#define FRAMEBUFFER_H

//

#define BACKGROUND_COLOR 0
#define FONT1_COLOR		 1
#define GB_COLOR_0		 2
#define GB_COLOR_1		 3
#define GB_COLOR_2		 4
#define GB_COLOR_3		 5

//

#define PIXEL	unsigned short int

#define Make32bColor6bpp(r,g,b) ((b<<2)|((g<<2)<<8)|((r<<2)<<16))
#define Make32bColor8bpp(r,g,b) ((b)|(g<<8)|(r<<16))

#define Make16bColor6bpp(r,g,b) ((b>>1)|(g<<5)|((r>>1)<<11))
#define Make16bColor8bpp(r,g,b) ( (b>>3) | ((g>>2)<<5) | ((r>>3)<<11) )

#define Get32bRedComponent(c) ((c>>16)&0xff)
#define Get32bGreenComponent(c) ((c>>8)&0xff)
#define Get32bBlueComponent(c) (c&0xff)

#define Get16bRedComponent(c) ((c>>11)&0x1f)
#define Get16bGreenComponent(c) ((c>>5)&0x3f)
#define Get16bBlueComponent(c) (c&0x1f)

PIXEL mixColors(int r1,int r2,
				int g1,int g2,
				int b1,int b2);

//

typedef struct
{
	// palette of 256 distinct colours 
	PIXEL palette[256];

	// the framebuffer
	int bufx;
	int bufy;
	PIXEL* vbuf;

} framebuffer;

#endif